/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.client;

import java.util.List;
import java.util.Map;
import mod.azure.azurelib.config.Config;
import mod.azure.azurelib.config.ConfigHolder;
import mod.azure.azurelib.config.client.screen.ConfigGroupScreen;
import mod.azure.azurelib.config.client.screen.ConfigScreen;
import mod.azure.azurelib.config.value.ConfigValue;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public final class AzureLibClient {
    @Nullable
    public static Screen getConfigScreen(Class<?> configClass, Screen previous) {
        Config cfg = configClass.getAnnotation(Config.class);
        if (cfg == null) {
            return null;
        }
        String id = cfg.id();
        return AzureLibClient.getConfigScreen(id, previous);
    }

    @Nullable
    public static Screen getConfigScreen(String configId, Screen previous) {
        return ConfigHolder.getConfig(configId).map(holder -> AzureLibClient.getConfigScreenForHolder(holder, previous)).orElse(null);
    }

    public static Screen getConfigScreenByGroup(String group, Screen previous) {
        List<ConfigHolder<?>> list = ConfigHolder.getConfigsByGroup(group);
        if (list.isEmpty()) {
            return null;
        }
        return AzureLibClient.getConfigScreenByGroup(list, group, previous);
    }

    public static Screen getConfigScreenForHolder(ConfigHolder<?> holder, Screen previous) {
        Map<String, ConfigValue<?>> valueMap = holder.getValueMap();
        return new ConfigScreen(holder.getConfigId(), holder.getConfigId(), valueMap, previous);
    }

    public static Screen getConfigScreenByGroup(List<ConfigHolder<?>> group, String groupId, Screen previous) {
        return new ConfigGroupScreen(previous, groupId, group);
    }
}

