/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.animation.AzAnimationContext;
import mod.azure.azurelib.animation.AzAnimationTimer;
import mod.azure.azurelib.animation.AzAnimatorConfig;
import mod.azure.azurelib.animation.AzCachedBoneUpdateUtil;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.model.AzBoneSnapshot;

public class AzBoneCache {
    private AzBakedModel templateModel;
    private AzBakedModel bakedModel;
    private final Map<String, AzBoneSnapshot> boneSnapshotsByName = new Object2ObjectOpenHashMap();

    public AzBoneCache() {
        this.setBakedModel(AzBakedModel.getDefault());
    }

    public boolean setActiveModel(AzBakedModel model) {
        if (model == null) {
            this.templateModel = null;
            this.bakedModel = AzBakedModel.getDefault();
            this.boneSnapshotsByName.clear();
            return true;
        }
        if (this.templateModel == model) {
            return false;
        }
        this.templateModel = model;
        this.bakedModel = model.deepCopy();
        this.boneSnapshotsByName.clear();
        this.snapshot();
        return true;
    }

    public void update(AzAnimationContext<?> context) {
        AzAnimatorConfig config = context.config();
        AzAnimationTimer timer = context.timer();
        double animTime = timer.getAnimTime();
        Map<String, AzBoneSnapshot> boneSnapshots = this.getBoneSnapshotsByName();
        double resetTickLength = config.boneResetTime();
        for (AzBone bone : this.bakedModel.getBonesByName().values()) {
            AzCachedBoneUpdateUtil.updateCachedBoneRotation(bone, boneSnapshots, animTime, resetTickLength);
            AzCachedBoneUpdateUtil.updateCachedBonePosition(bone, boneSnapshots, animTime, resetTickLength);
            AzCachedBoneUpdateUtil.updateCachedBoneScale(bone, boneSnapshots, animTime, resetTickLength);
        }
        this.resetBoneTransformationMarkers();
    }

    private void resetBoneTransformationMarkers() {
        this.bakedModel.getBonesByName().values().forEach(AzBone::resetStateChanges);
    }

    private void snapshot() {
        this.boneSnapshotsByName.clear();
        for (AzBone bone : this.bakedModel.getBonesByName().values()) {
            this.boneSnapshotsByName.put(bone.getName(), AzBoneSnapshot.copy(bone.getInitialAzSnapshot()));
        }
    }

    public void setBakedModel(AzBakedModel model) {
        this.bakedModel = model != null ? model : AzBakedModel.getDefault();
    }

    public AzBakedModel getBakedModel() {
        return this.bakedModel;
    }

    public Map<String, AzBoneSnapshot> getBoneSnapshotsByName() {
        return this.boneSnapshotsByName;
    }

    public boolean isEmpty() {
        return this.bakedModel.getBonesByName().isEmpty();
    }
}

