/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.hearth_and_home.block;

import com.starfish_studios.hearth_and_home.block.properties.ModBlockStateProperties;
import com.starfish_studios.hearth_and_home.registry.HNHSoundEvents;
import com.starfish_studios.hearth_and_home.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChimneyBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape NECK = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape LIP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape COLUMN = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty TOP = ModBlockStateProperties.TOP;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final int SMOKE_DISTANCE = 5;

    public ChimneyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelAccessor = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        boolean top = this.getTopState(levelAccessor.m_8055_(blockPos.m_7494_()));
        boolean bl = levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!bl));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)TOP) != false ? Shapes.m_83110_((VoxelShape)NECK, (VoxelShape)LIP) : COLUMN;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() || !((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return;
        }
        if (random.m_188503_(10) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, HNHSoundEvents.CHIMNEY_CRACKLE.get(), SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
        if (random.m_188503_(5) == 0) {
            for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.m_188501_() / 2.0f), 5.0E-5, (double)(random.m_188501_() / 2.0f));
            }
        }
        SimpleParticleType simpleParticleType = ParticleTypes.f_123777_;
        level.m_6485_((ParticleOptions)simpleParticleType, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ItemTags.f_271138_) && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            level.m_247517_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(ItemTags.f_262757_) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            Utils.hurtStack(player, stack, hand);
            level.m_247517_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean waterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
        if (waterlogged) {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
            }
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == Direction.UP) {
            state = (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(this.getTopState(neighborState)));
            if (neighborState.m_60734_() instanceof ChimneyBlock) {
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)neighborState.m_61143_((Property)LIT) != false && !waterlogged));
            }
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean getTopState(BlockState above) {
        return !(above.m_60734_() instanceof ChimneyBlock);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && ((Boolean)state.m_61143_((Property)TOP)).booleanValue() && !level.m_5776_()) {
            level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED, TOP});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return true;
    }
}

