/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.extension.item;

import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.registry.factory.common.ItemFactory;
import java.util.function.Supplier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public interface ArmorExtension {
    default public RegistryObject<ArmorItem> createArmor(String name, ArmorMaterial material, ArmorItem.Type type) {
        return this.createArmor(name, material, type, new Item.Properties());
    }

    default public RegistryObject<ArmorItem> createArmor(String name, ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        ItemFactory itemFactory = InjectionContext.getInstance().getObject(ItemFactory.class);
        return itemFactory.createTyped(name, (Supplier<? extends Item>)((Supplier<Item>)() -> new ArmorItem(material, type, properties)));
    }

    default public RegistryObject<? extends ArmorItem> createArmor(String name, Supplier<? extends ArrowItem> tTypedSupplier) {
        ItemFactory itemFactory = InjectionContext.getInstance().getObject(ItemFactory.class);
        return itemFactory.createTyped(name, (Supplier<? extends Item>)tTypedSupplier);
    }
}

