/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.common;

import com.google.common.collect.ImmutableSet;
import com.temporal.api.core.engine.event.registry.EnginedRegisterFactory;
import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.registry.factory.common.TypedFactory;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class PoiTypeFactory
implements TypedFactory<PoiType> {
    public static final DeferredRegister<PoiType> POI_TYPES = EnginedRegisterFactory.create(Registries.f_256805_);

    public RegistryObject<PoiType> create(String name, Block block, int maxTickets, int validRange) {
        return this.create(name, (Set<BlockState>)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), maxTickets, validRange);
    }

    public RegistryObject<PoiType> create(String name, Set<BlockState> matchingStates, int maxTickets, int validRange) {
        return this.create(name, () -> new PoiType(matchingStates, maxTickets, validRange));
    }

    @Override
    public RegistryObject<PoiType> create(String name, Supplier<PoiType> poiSupplier) {
        return POI_TYPES.register(name, poiSupplier);
    }

    @Override
    public RegistryObject<? extends PoiType> createTyped(String name, Supplier<? extends PoiType> tSupplier) {
        return POI_TYPES.register(name, tSupplier);
    }

    @Override
    public void register() {
        POI_TYPES.register(InjectionContext.getInstance().getObject(IEventBus.class));
    }
}

