/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.common;

import com.temporal.api.core.engine.event.registry.EnginedRegisterFactory;
import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.registry.factory.common.ItemFactory;
import com.temporal.api.core.registry.factory.common.TypedFactory;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class BlockFactory
implements TypedFactory<Block> {
    public static final DeferredRegister<Block> BLOCKS = EnginedRegisterFactory.create(Registries.f_256747_);
    private final ItemFactory itemFactory = InjectionContext.getInstance().getObject(ItemFactory.class);

    public RegistryObject<Block> create(String name, BlockBehaviour.Properties properties) {
        return this.create(name, () -> new Block(properties));
    }

    @Override
    public RegistryObject<Block> create(String name, Supplier<Block> blockSupplier) {
        RegistryObject block = BLOCKS.register(name, blockSupplier);
        this.itemFactory.createTyped(name, (Supplier<? extends Item>)((Supplier<Item>)() -> new BlockItem((Block)block.get(), new Item.Properties())));
        return block;
    }

    @Override
    public RegistryObject<? extends Block> createTyped(String name, Supplier<? extends Block> typedBlockSupplier) {
        RegistryObject typedBlock = BLOCKS.register(name, typedBlockSupplier);
        this.itemFactory.createTyped(name, (Supplier<? extends Item>)((Supplier<Item>)() -> new BlockItem((Block)typedBlock.get(), new Item.Properties())));
        return typedBlock;
    }

    @Override
    public void register() {
        BLOCKS.register(InjectionContext.getInstance().getObject(IEventBus.class));
    }
}

