/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.event.data.recipe;

import com.temporal.api.core.event.data.recipe.holder.CookingRecipeHolder;
import com.temporal.api.core.event.data.recipe.holder.RecipeHolder;
import com.temporal.api.core.event.data.recipe.holder.ShapedRecipeHolder;
import com.temporal.api.core.event.data.recipe.holder.ShapelessRecipeHolder;
import com.temporal.api.core.event.data.recipe.holder.SmithingTransformRecipeHolder;
import com.temporal.api.core.event.data.recipe.holder.SmithingTrimRecipeHolder;
import com.temporal.api.core.event.data.recipe.holder.StoneCuttingRecipeHolder;
import com.temporal.api.core.event.data.recipe.strategy.CookingRecipeStrategy;
import com.temporal.api.core.event.data.recipe.strategy.RecipeStrategy;
import com.temporal.api.core.event.data.recipe.strategy.ShapedRecipeStrategy;
import com.temporal.api.core.event.data.recipe.strategy.ShapelessRecipeStrategy;
import com.temporal.api.core.event.data.recipe.strategy.SmithingTransformRecipeStrategy;
import com.temporal.api.core.event.data.recipe.strategy.SmithingTrimRecipeStrategy;
import com.temporal.api.core.event.data.recipe.strategy.StoneCuttingRecipeStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ApiRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public static final List<RecipeHolder> RECIPES = new ArrayList<RecipeHolder>();
    private static final RecipeStrategy<ShapelessRecipeHolder> SHAPELESS_RECIPE_STRATEGY = new ShapelessRecipeStrategy();
    private static final RecipeStrategy<ShapedRecipeHolder> SHAPED_RECIPE_STRATEGY = new ShapedRecipeStrategy();
    private static final RecipeStrategy<CookingRecipeHolder> COOKING_RECIPE_STRATEGY = new CookingRecipeStrategy();
    private static final RecipeStrategy<SmithingTrimRecipeHolder> SMITHING_TRIM_RECIPE_STRATEGY = new SmithingTrimRecipeStrategy();
    private static final RecipeStrategy<SmithingTransformRecipeHolder> SMITHING_TRANSFORM_RECIPE_STRATEGY = new SmithingTransformRecipeStrategy();
    private static final RecipeStrategy<StoneCuttingRecipeHolder> STONE_CUTTING_RECIPE_STRATEGY_RECIPE_STRATEGY = new StoneCuttingRecipeStrategy();

    public ApiRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> recipeConsumer) {
        RECIPES.forEach(undefinedRecipe -> {
            if (undefinedRecipe instanceof ShapelessRecipeHolder) {
                ShapelessRecipeHolder recipe = (ShapelessRecipeHolder)undefinedRecipe;
                SHAPELESS_RECIPE_STRATEGY.saveRecipe(recipe, recipeConsumer);
            } else if (undefinedRecipe instanceof ShapedRecipeHolder) {
                ShapedRecipeHolder recipe = (ShapedRecipeHolder)undefinedRecipe;
                SHAPED_RECIPE_STRATEGY.saveRecipe(recipe, recipeConsumer);
            } else if (undefinedRecipe instanceof CookingRecipeHolder) {
                CookingRecipeHolder recipe = (CookingRecipeHolder)undefinedRecipe;
                COOKING_RECIPE_STRATEGY.saveRecipe(recipe, recipeConsumer);
            } else if (undefinedRecipe instanceof SmithingTrimRecipeHolder) {
                SmithingTrimRecipeHolder recipe = (SmithingTrimRecipeHolder)undefinedRecipe;
                SMITHING_TRIM_RECIPE_STRATEGY.saveRecipe(recipe, recipeConsumer);
            } else if (undefinedRecipe instanceof SmithingTransformRecipeHolder) {
                SmithingTransformRecipeHolder recipe = (SmithingTransformRecipeHolder)undefinedRecipe;
                SMITHING_TRANSFORM_RECIPE_STRATEGY.saveRecipe(recipe, recipeConsumer);
            } else if (undefinedRecipe instanceof StoneCuttingRecipeHolder) {
                StoneCuttingRecipeHolder recipe = (StoneCuttingRecipeHolder)undefinedRecipe;
                STONE_CUTTING_RECIPE_STRATEGY_RECIPE_STRATEGY.saveRecipe(recipe, recipeConsumer);
            }
        });
    }

    public static String m_176602_(ItemLike itemLike) {
        return "has_" + ApiRecipeProvider.m_176632_(itemLike);
    }

    @NotNull
    public static String m_176632_(ItemLike itemLike) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_())).m_135815_();
    }

    public static InventoryChangeTrigger.TriggerInstance m_125977_(@NotNull ItemLike itemLike) {
        return ApiRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}).m_45077_()});
    }
}

