/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine;

import com.temporal.api.ApiMod;
import com.temporal.api.core.engine.EngineLayer;
import com.temporal.api.core.engine.IOLayer;
import com.temporal.api.core.engine.LayerContainer;
import com.temporal.api.core.engine.io.context.ContextInitializer;
import com.temporal.api.core.engine.io.context.ExtraContextInitializer;
import java.util.ArrayList;
import java.util.List;

public class TemporalEngine {
    private static final String BANNER = "   _________ _________ ___     ___ _________\n   ---- ---- |   ----| |  \\   / | |  ___  |\n      | |    |  |      | | \\ /| | |  | |  |\n      | |    |   --|   | |    | | |  ---  |\n      | |    |   --|   | |    | | |  -----|\n      | |    |  |      | |    | | | |\n      | |    |  -----| | |    | | | |\n      |-|    --------| |-|    |-| |-|\n";

    public static LayerContainer run(Class<?> modClass) {
        return TemporalEngine.config().addLayer(new IOLayer()).processIOLayer(modClass, new ExtraContextInitializer()).build();
    }

    public static Configurator config() {
        return new Configurator();
    }

    public static class Configurator {
        private static final String LOAD_MESSAGE = "{} has been loaded!";
        private final LayerContainer layerContainer = LayerContainer.getInstance();
        private final List<Task> tasks = new ArrayList<Task>(2);

        private Configurator() {
        }

        public Configurator addLayer(EngineLayer engineLayer) {
            this.tasks.add(() -> this.layerContainer.add(engineLayer));
            return this;
        }

        public Configurator disableLayer(Class<? extends EngineLayer> engineLayerClass) {
            this.tasks.add(() -> this.layerContainer.delete(engineLayerClass));
            return this;
        }

        public Configurator processIOLayer(Class<?> modClass, ContextInitializer ... contextInitializers) {
            Task ioSetupTask = () -> {
                IOLayer ioLayer = (IOLayer)this.layerContainer.getLayer(IOLayer.class);
                ioLayer.setModClass(modClass);
                ioLayer.setContextInitializers(List.of(contextInitializers));
                this.logLayerProcession(ioLayer);
            };
            this.tasks.add(ioSetupTask);
            return this;
        }

        public LayerContainer build() {
            System.out.println(TemporalEngine.BANNER);
            this.tasks.forEach(Task::execute);
            ApiMod.LOGGER.info("Mod: {} has been registered as a TemporalEngine component!", (Object)IOLayer.FORGE_MOD);
            return this.layerContainer;
        }

        private void logLayerProcession(EngineLayer engineLayer) {
            engineLayer.processAllTasks();
            ApiMod.LOGGER.info(LOAD_MESSAGE, (Object)engineLayer.getClass().getSimpleName());
        }
    }

    @FunctionalInterface
    public static interface Task {
        public void execute();
    }
}

