/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity.ai.goal;

import com.izofar.bygonenether.entity.IShieldedMob;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;

public class ShieldGoal<T extends Mob>
extends Goal {
    protected final Class<? extends LivingEntity> targetType;
    protected final T mob;
    private int shieldCoolDown;
    private int shieldWarmup;
    private int shieldStagger;
    private int shieldDelay;
    @Nullable
    protected LivingEntity target;
    protected final TargetingConditions targetConditions;

    public ShieldGoal(T mob, Class<? extends LivingEntity> targetType) {
        this.mob = mob;
        this.targetType = targetType;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.getFollowDistance()).m_26888_(null);
    }

    public boolean m_8036_() {
        this.findTarget();
        return this.target != null;
    }

    public boolean m_8045_() {
        if (((IShieldedMob)this.mob).isShieldDisabled()) {
            return false;
        }
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        if (this.mob.m_20280_((Entity)this.target) > this.getFollowDistance() * this.getFollowDistance()) {
            return false;
        }
        return this.getStage() != ShieldStage.INACTIVE;
    }

    public void m_8056_() {
        this.mob.m_6710_(this.target);
        this.shieldDelay = this.m_183277_(3 + this.mob.m_217043_().m_188503_(3));
        this.shieldStagger = this.m_183277_(15 + this.mob.m_217043_().m_188503_(25));
        this.setDefaultCounters();
        super.m_8056_();
    }

    public void m_8041_() {
        this.target = null;
        this.setDefaultCounters();
        ((IShieldedMob)this.mob).stopUsingShield();
    }

    public void m_8037_() {
        switch (this.getStage()) {
            case INACTIVE: {
                this.setDefaultCounters();
                break;
            }
            case WARMUP: {
                --this.shieldWarmup;
                break;
            }
            case ACTIVE: {
                if (this.mob.m_5448_() == null) {
                    return;
                }
                this.mob.m_21563_().m_24950_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20188_(), this.mob.m_5448_().m_20189_(), 10.0f, (float)this.mob.m_8132_());
                ((IShieldedMob)this.mob).startUsingShield();
                this.setDefaultCounters();
                break;
            }
            case COOLDOWN: {
                --this.shieldCoolDown;
            }
        }
    }

    private static boolean targetDrawnBow(LivingEntity target) {
        if (target == null) {
            return false;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            boolean chargedCrossbow;
            ItemStack itemstack = target.m_21120_(interactionhand);
            boolean drawnBow = itemstack.m_150930_(Items.f_42411_) && target.m_6117_();
            boolean bl = chargedCrossbow = itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack);
            if (!drawnBow && !chargedCrossbow) continue;
            return true;
        }
        return false;
    }

    protected AABB getTargetSearchArea(double radius) {
        return this.mob.m_20191_().m_82377_(radius, 4.0, radius);
    }

    protected void findTarget() {
        Object potentialTarget = this.targetType != Player.class && this.targetType != ServerPlayer.class ? this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), livingEntity -> true), this.targetConditions, this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()) : this.mob.m_9236_().m_45949_(this.targetConditions, this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        this.target = ShieldGoal.targetDrawnBow((LivingEntity)potentialTarget) ? potentialTarget : null;
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }

    private void setDefaultCounters() {
        this.shieldWarmup = this.shieldDelay;
        this.shieldCoolDown = this.shieldStagger;
    }

    private ShieldStage getStage() {
        if (ShieldGoal.targetDrawnBow(this.target)) {
            if (this.shieldWarmup <= 0) {
                this.shieldWarmup = 0;
                return ShieldStage.ACTIVE;
            }
            return ShieldStage.WARMUP;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCoolDown = 0;
            return ShieldStage.INACTIVE;
        }
        return ShieldStage.COOLDOWN;
    }

    private static enum ShieldStage {
        INACTIVE,
        WARMUP,
        ACTIVE,
        COOLDOWN;

    }
}

