/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.emissivity;

import com.aetherteam.emissivity.EmissivityConfig;
import com.aetherteam.emissivity.data.generators.EmissivityLanguageData;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;

@Mod(value="aether_emissivity")
public class Emissivity {
    public static final String MODID = "aether_emissivity";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Emissivity() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::dataSetup);
        modEventBus.addListener(this::packSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EmissivityConfig.CLIENT_SPEC);
    }

    public void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new EmissivityLanguageData(packOutput));
        PackMetadataGenerator packMeta = new PackMetadataGenerator(packOutput);
        Map<PackType, Integer> packTypes = Map.of(PackType.SERVER_DATA, SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
        packMeta.m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether_emissivity.mod.description"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), packTypes));
        generator.addProvider(true, (DataProvider)packMeta);
    }

    public void packSetup(AddPackFindersEvent event) {
        this.setupRecipeOverridePack(event);
    }

    private void setupRecipeOverridePack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/model_override"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237113_((String)""), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/emissivity_model_override", (Component)Component.m_237113_((String)""), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }
}

