/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.permission.impl;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI;

public class PlayerLuckPermsSystem
implements IPlayerPermissionSystemAPI {
    private QueryOptions queryOptions;
    private static final Map<Class<?>, Function<String, ?>> PARSERS = Map.of(Integer.class, Integer::valueOf, Double.class, Double::valueOf, Float.class, Float::valueOf, Long.class, Long::valueOf, Short.class, Short::valueOf, Byte.class, Byte::valueOf, String.class, Function.identity(), Component.class, Component::m_237113_);

    @Override
    @Nonnull
    public OptionalInt getIntPermission(@Nonnull ServerPlayer player, @Nonnull IPermissionNodeAPI<Integer> node) {
        CachedMetaData cachedMetaData = this.getCachedMetaData(player);
        if (cachedMetaData == null) {
            return OptionalInt.empty();
        }
        Integer parsedInteger = cachedMetaData.getMetaValue(node.getNodeString(), Integer::parseInt).orElse(null);
        if (parsedInteger == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(parsedInteger);
    }

    @Override
    public boolean getPermission(@Nonnull ServerPlayer player, @Nonnull IPermissionNodeAPI<Boolean> node) {
        User user = this.getUser(player);
        if (user == null) {
            return false;
        }
        this.ensureQueryOptions();
        CachedDataManager cachedDataManager = user.getCachedData();
        CachedPermissionData cachedPermissionData = cachedDataManager.getPermissionData(this.queryOptions);
        return cachedPermissionData.checkPermission(node.getNodeString()).asBoolean();
    }

    @Override
    @Nonnull
    public <T> Optional<T> getPermissionTyped(@Nonnull ServerPlayer player, @Nonnull IPermissionNodeAPI<T> node) {
        if (node.getType() == Boolean.class) {
            Optional<Boolean> booleanValue = Optional.of(this.getPermission(player, node));
            return booleanValue;
        }
        CachedMetaData cachedMetaData = this.getCachedMetaData(player);
        if (cachedMetaData == null) {
            return Optional.empty();
        }
        Function<String, ?> parser = PARSERS.get(node.getType());
        if (parser == null) {
            return Optional.empty();
        }
        Object parsedValue = cachedMetaData.getMetaValue(node.getNodeString(), parser).orElse(null);
        return Optional.ofNullable(parsedValue);
    }

    private void ensureQueryOptions() {
        if (this.queryOptions == null) {
            this.queryOptions = QueryOptions.defaultContextualOptions();
        }
    }

    private User getUser(ServerPlayer player) {
        LuckPerms luckPerms;
        try {
            luckPerms = LuckPermsProvider.get();
        }
        catch (Exception ignored) {
            return null;
        }
        UserManager userManager = luckPerms.getUserManager();
        User user = null;
        if (!userManager.isLoaded(player.m_20148_())) {
            try {
                user = (User)userManager.loadUser(player.m_20148_()).join();
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("suppressed exception", t);
            }
        } else {
            user = userManager.getUser(player.m_20148_());
        }
        return user;
    }

    private CachedMetaData getCachedMetaData(ServerPlayer player) {
        User user = this.getUser(player);
        if (user == null) {
            return null;
        }
        this.ensureQueryOptions();
        CachedDataManager cachedDataManager = user.getCachedData();
        return cachedDataManager.getMetaData(this.queryOptions);
    }
}

