/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.lazypacket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public abstract class LazyPacket<P extends LazyPacket<P>> {
    private final FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
    private boolean prepared;

    protected abstract Function<FriendlyByteBuf, P> getDecoder();

    public int getPreparedSize() {
        if (!this.prepared) {
            throw new IllegalStateException("Lazy packet has not been prepared!");
        }
        return this.data.writerIndex();
    }

    public int prepare() {
        if (this.prepared) {
            return this.data.writerIndex();
        }
        this.data.clear();
        this.writeOnPrepare(this.data);
        this.prepared = true;
        return this.data.writerIndex();
    }

    protected abstract void writeOnPrepare(FriendlyByteBuf var1);

    public static abstract class Handler<P extends LazyPacket<P>>
    implements Consumer<P> {
        protected abstract void handle(P var1);

        @Override
        public void accept(P t) {
            P lazyPacket = t;
            if (((LazyPacket)lazyPacket).prepared) {
                ((LazyPacket)lazyPacket).data.readerIndex(0);
                LazyPacket decoded = (LazyPacket)((LazyPacket)lazyPacket).getDecoder().apply(((LazyPacket)lazyPacket).data);
                this.handle(decoded);
                return;
            }
            this.handle(t);
        }
    }

    public static class Encoder<P extends LazyPacket<P>>
    implements BiConsumer<P, FriendlyByteBuf> {
        @Override
        public void accept(P t, FriendlyByteBuf u) {
            P lazyPacket = t;
            if (!((LazyPacket)lazyPacket).prepared) {
                throw new IllegalStateException("Lazy packet has not been prepared!");
            }
            u.writeBytes((ByteBuf)((LazyPacket)lazyPacket).data, 0, ((LazyPacket)lazyPacket).data.writerIndex());
        }
    }
}

