/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.gui.OtherPlayerConfigWaitScreen;
import xaero.pac.client.player.config.IPlayerConfigClientStorage;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.IPlayerConfigStringableOptionClientStorage;
import xaero.pac.common.packet.config.ClientboundPlayerConfigAbstractStatePacket;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class ClientboundPlayerConfigSyncStatePacket
extends ClientboundPlayerConfigAbstractStatePacket {
    private final boolean state;

    public ClientboundPlayerConfigSyncStatePacket(PlayerConfigType type, boolean otherPlayer, boolean state) {
        super(type, otherPlayer, "main");
        this.state = state;
    }

    public static class ClientHandler
    extends ClientboundPlayerConfigAbstractStatePacket.ClientHandler<ClientboundPlayerConfigSyncStatePacket> {
        @Override
        protected void accept(ClientboundPlayerConfigSyncStatePacket t, IPlayerConfigClientStorageManager<IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>> playerConfigStorageManager, IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>> storage) {
            OtherPlayerConfigWaitScreen waitScreen;
            OtherPlayerConfigWaitScreen.Listener listener;
            Screen screen;
            if (!t.isOtherPlayer() && !storage.isSyncInProgress() && t.state) {
                storage.reset();
            }
            storage.setSyncInProgress(t.state);
            if (!t.state && t.isOtherPlayer() && (screen = Minecraft.m_91087_().f_91080_) instanceof OtherPlayerConfigWaitScreen && (listener = (waitScreen = (OtherPlayerConfigWaitScreen)screen).getListener()) != null) {
                listener.onConfigDataSyncDone(storage);
            }
        }
    }

    public static class Codec
    extends ClientboundPlayerConfigAbstractStatePacket.Codec<ClientboundPlayerConfigSyncStatePacket> {
        @Override
        protected ClientboundPlayerConfigSyncStatePacket decode(CompoundTag nbt, PlayerConfigType type, boolean otherPlayer, String subId) {
            if (!nbt.m_128425_("s", 1)) {
                OpenPartiesAndClaims.LOGGER.info("Unknown player config sync state!");
                return null;
            }
            boolean state = nbt.m_128471_("s");
            return new ClientboundPlayerConfigSyncStatePacket(type, otherPlayer, state);
        }

        @Override
        protected void encode(ClientboundPlayerConfigSyncStatePacket packet, CompoundTag nbt) {
            nbt.m_128379_("s", packet.state);
        }

        @Override
        protected int getExtraSizeLimit() {
            return 0;
        }
    }
}

