/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mods.prometheus;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import earth.terrarium.prometheus.api.roles.options.RoleOption;
import earth.terrarium.prometheus.api.roles.options.RoleOptionSerializer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.UsedPermissionNodes;

public class OPACOptions
implements RoleOption<OPACOptions> {
    protected static final ResourceLocation resourceLocation = new ResourceLocation("openpartiesandclaims", "permissions");
    protected final Map<IPermissionNodeAPI<?>, Object> values = new LinkedHashMap();
    public static final RoleOptionSerializer<OPACOptions> SERIALIZER = RoleOptionSerializer.of((ResourceLocation)resourceLocation, (int)1, (Codec)Codec.of(OPACOptions.getEncoder(), OPACOptions.getDecoder(OPACOptions::new)), (RoleOption)new OPACOptions());

    public <T> T getValue(IPermissionNodeAPI<T> node) {
        return (T)this.values.get(node);
    }

    public <T> T getValueCast(IPermissionNodeAPI<?> node) {
        return (T)this.getValue(node);
    }

    public <T> void setValue(IPermissionNodeAPI<T> node, T value) {
        this.values.put(node, value);
    }

    public void setValueCast(IPermissionNodeAPI<?> node, Object value) {
        if (value != null && !node.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(node.getType() + " is not assignable from " + value.getClass());
        }
        this.values.put(node, value);
    }

    public RoleOptionSerializer<OPACOptions> serializer() {
        return SERIALIZER;
    }

    private static <T> BiFunction<DynamicOps<T>, Object, T> getValueEncoder(Class<?> type) {
        if (type == Boolean.class) {
            return (ops, o) -> ops.createBoolean(((Boolean)o).booleanValue());
        }
        if (type == Integer.class) {
            return (ops, o) -> ops.createInt(((Integer)o).intValue());
        }
        if (type == Double.class) {
            return (ops, o) -> ops.createDouble(((Double)o).doubleValue());
        }
        if (type == Float.class) {
            return (ops, o) -> ops.createFloat(((Float)o).floatValue());
        }
        if (type == Long.class) {
            return (ops, o) -> ops.createLong(((Long)o).longValue());
        }
        if (type == Short.class) {
            return (ops, o) -> ops.createShort(((Short)o).shortValue());
        }
        if (type == Byte.class) {
            return (ops, o) -> ops.createByte(((Byte)o).byteValue());
        }
        if (type == String.class) {
            return (ops, o) -> ops.createString((String)o);
        }
        if (type == Component.class) {
            return (ops, o) -> ops.createString(Component.Serializer.m_130703_((Component)((Component)o)));
        }
        return null;
    }

    private static <T, V> BiFunction<DynamicOps<T>, T, Optional<V>> getValueDecoder(Class<V> type) {
        if (type == Boolean.class) {
            return (ops, o) -> ops.getBooleanValue(o).result();
        }
        if (type == Integer.class) {
            return (ops, o) -> ops.getNumberValue(o).result().map(Number::intValue);
        }
        if (type == Double.class) {
            return (ops, o) -> ops.getNumberValue(o).result().map(Number::doubleValue);
        }
        if (type == Float.class) {
            return (ops, o) -> ops.getNumberValue(o).result().map(Number::floatValue);
        }
        if (type == Long.class) {
            return (ops, o) -> ops.getNumberValue(o).result().map(Number::longValue);
        }
        if (type == Short.class) {
            return (ops, o) -> ops.getNumberValue(o).result().map(Number::shortValue);
        }
        if (type == Byte.class) {
            return (ops, o) -> ops.getNumberValue(o).result().map(Number::byteValue);
        }
        if (type == String.class) {
            return (ops, o) -> ops.getStringValue(o).result();
        }
        if (type == Component.class) {
            return (ops, o) -> ops.getStringValue(o).result().map(Component.Serializer::m_130701_);
        }
        return null;
    }

    protected static Encoder<OPACOptions> getEncoder() {
        return new Encoder<OPACOptions>(){

            public <T> DataResult<T> encode(OPACOptions input, DynamicOps<T> ops, T prefix) {
                Object map = ops.createMap(new LinkedHashMap());
                for (Map.Entry<IPermissionNodeAPI<?>, Object> entry : input.values.entrySet()) {
                    IPermissionNodeAPI<?> node = entry.getKey();
                    Object value = entry.getValue();
                    Object encodedNode = ops.createString(node.getDefaultNodeString());
                    T encodedValue = OPACOptions.encodeValue(ops, node, value);
                    if (encodedValue == null) continue;
                    map = ops.mergeToMap(map, encodedNode, encodedValue).result().orElse(map);
                }
                return DataResult.success((Object)map);
            }
        };
    }

    protected static Decoder<OPACOptions> getDecoder(final Supplier<OPACOptions> factory) {
        return new Decoder<OPACOptions>(){

            public <T> DataResult<Pair<OPACOptions, T>> decode(DynamicOps<T> ops, T input) {
                OPACOptions options = (OPACOptions)factory.get();
                ops.getMapEntries(input).get().ifLeft(c -> c.accept((encodedNode, encodedValue) -> {
                    String key = ops.getStringValue(encodedNode).result().orElse(null);
                    if (key == null) {
                        return;
                    }
                    IPermissionNodeAPI node = (IPermissionNodeAPI)UsedPermissionNodes.ALL.get((Object)key);
                    if (node == null) {
                        return;
                    }
                    Optional result = OPACOptions.decodeValue(ops, node, encodedValue);
                    if (result.isEmpty()) {
                        options.values.remove(node);
                        return;
                    }
                    options.values.put(node, result.get());
                }));
                return DataResult.success((Object)Pair.of((Object)options, input));
            }
        };
    }

    private static <T> T encodeValue(DynamicOps<T> ops, IPermissionNodeAPI<?> node, Object value) {
        BiFunction<DynamicOps<DynamicOps<T>>, Object, DynamicOps<T>> valueEncoder = OPACOptions.getValueEncoder(node.getType());
        if (valueEncoder == null) {
            return null;
        }
        return valueEncoder.apply(ops, value);
    }

    private static <T, V> Optional<V> decodeValue(DynamicOps<T> ops, IPermissionNodeAPI<V> node, T encodedValue) {
        BiFunction<DynamicOps<DynamicOps<T>>, DynamicOps<T>, Optional<V>> decoder = OPACOptions.getValueDecoder(node.getType());
        if (decoder == null) {
            return Optional.empty();
        }
        return decoder.apply((DynamicOps<DynamicOps<T>>)ops, (DynamicOps<T>)encodedValue);
    }
}

