/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.world.level.block.entity;

import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.capability.ItemFrameColorCapability;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.puzzleslib.api.block.v1.TickingBlockEntity;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class ItemFrameBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    static final String TAG_ITEM_FRAME = FastItemFrames.id("item_frame").toString();
    @Nullable
    private ItemFrame itemFrame;
    @Nullable
    private CompoundTag storedTag;
    @Nullable
    private Integer color;

    public ItemFrameBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.m_203334_(), pos, blockState);
    }

    public void serverTick() {
        Integer integer;
        MapItemSavedData mapItemSavedData;
        ItemStack itemStack;
        if (this.m_58898_() && ((ServerLevel)this.m_58904_()).m_7654_().m_129921_() % 10 == 0 && (itemStack = this.getItem()).m_41720_() instanceof MapItem && (mapItemSavedData = MapItem.m_151128_((Integer)(integer = MapItem.m_151131_((ItemStack)itemStack)), (Level)this.m_58904_())) != null) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.m_58904_()).m_6907_()) {
                mapItemSavedData.m_77918_((Player)serverPlayer, itemStack);
                Packet packet = mapItemSavedData.m_164796_(integer.intValue(), (Player)serverPlayer);
                if (packet == null) continue;
                serverPlayer.f_8906_.m_9829_(packet);
            }
        }
    }

    public void load(ItemFrame itemFrame) {
        CompoundTag compoundTag = new CompoundTag();
        itemFrame.m_7380_(compoundTag);
        this.loadItemFrame(compoundTag);
        ((ItemFrameColorCapability)ModRegistry.ITEM_FRAME_COLOR_CAPABILITY.get((Object)itemFrame)).getColor().ifPresent(this::setColor);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128425_(TAG_ITEM_FRAME, 10)) {
            this.loadItemFrame(tag.m_128469_(TAG_ITEM_FRAME));
        }
        this.color = tag.m_128425_("color", 3) ? Integer.valueOf(tag.m_128451_("color")) : null;
    }

    protected void m_183515_(CompoundTag tag) {
        CompoundTag itemFrameTag = this.getItemFrameTag();
        if (itemFrameTag != null) {
            tag.m_128365_(TAG_ITEM_FRAME, (Tag)itemFrameTag);
        }
        if (this.color != null) {
            tag.m_128405_("color", this.color.intValue());
        }
    }

    @Nullable
    private CompoundTag getItemFrameTag() {
        ItemFrame itemFrame = this.getEntityRepresentation();
        if (itemFrame != null) {
            CompoundTag compoundTag = new CompoundTag();
            itemFrame.m_7380_(compoundTag);
            return compoundTag;
        }
        if (this.storedTag != null) {
            return this.storedTag;
        }
        return null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setColor(int color) {
        if (this.color == null || this.color != color) {
            this.color = color;
        }
    }

    public OptionalInt getColor() {
        return this.color != null ? OptionalInt.of(this.color) : OptionalInt.empty();
    }

    public ItemStack getItem() {
        ItemFrame itemFrame = this.getEntityRepresentation();
        return itemFrame != null ? itemFrame.m_31822_() : ItemStack.f_41583_;
    }

    public boolean isInvisible() {
        return (Boolean)this.m_58900_().m_61143_((Property)ItemFrameBlock.INVISIBLE);
    }

    public void markUpdated() {
        if (this.m_58898_()) {
            this.m_58904_().m_7731_(this.m_58899_(), this.getUpdatedBlockState(), 2);
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private BlockState getUpdatedBlockState() {
        BlockState blockState = this.m_58900_();
        ItemFrame itemFrame = this.getEntityRepresentation();
        if (itemFrame != null) {
            return (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)ItemFrameBlock.HAS_MAP, (Comparable)Boolean.valueOf(itemFrame.m_218869_()))).m_61124_((Property)ItemFrameBlock.DYED, (Comparable)Boolean.valueOf(this.getColor().isPresent()))).m_61124_((Property)ItemFrameBlock.INVISIBLE, (Comparable)Boolean.valueOf(itemFrame.m_20145_() && !itemFrame.m_31822_().m_41619_()));
        }
        return blockState;
    }

    @Nullable
    public ItemFrame getEntityRepresentation() {
        return this.getEntityRepresentation(false);
    }

    @Nullable
    public ItemFrame getEntityRepresentation(boolean skipInit) {
        if (this.itemFrame == null && this.m_58898_()) {
            EntityType type = ((HangingEntityItem)this.m_58900_().m_60734_().m_5456_()).f_41322_;
            ItemFrame itemFrame = (ItemFrame)type.m_20615_(this.m_58904_());
            if (!skipInit) {
                this.initItemFrame(itemFrame, this.storedTag);
            }
            this.storedTag = null;
            this.itemFrame = itemFrame;
            return this.itemFrame;
        }
        return this.itemFrame;
    }

    private void loadItemFrame(CompoundTag compoundTag) {
        ItemFrame itemFrame = this.getEntityRepresentation(true);
        if (itemFrame != null) {
            this.initItemFrame(itemFrame, compoundTag);
        } else {
            this.storedTag = compoundTag.m_6426_();
        }
    }

    private void initItemFrame(ItemFrame itemFrame, @Nullable CompoundTag compoundTag) {
        itemFrame.m_31789_(ItemStack.f_41583_, false);
        BlockPos pos = this.m_58899_();
        itemFrame.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (compoundTag != null) {
            itemFrame.m_7378_(compoundTag);
        }
        itemFrame.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        itemFrame.m_6022_((Direction)this.m_58900_().m_61143_((Property)ItemFrameBlock.FACING));
    }
}

