/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unearthedjourney.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.unearthedjourney.UnearthedJourneyMod;
import net.mcreator.unearthedjourney.procedures.GettingStartedPage1OPENProcedure;
import net.mcreator.unearthedjourney.procedures.GettingStartedPage3OPENProcedure;
import net.mcreator.unearthedjourney.world.inventory.GettingStartedPage2Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GettingStartedPage2ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GettingStartedPage2ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GettingStartedPage2ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GettingStartedPage2ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GettingStartedPage2ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GettingStartedPage2ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GettingStartedPage2Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GettingStartedPage3OPENProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            GettingStartedPage1OPENProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        UnearthedJourneyMod.addNetworkMessage(GettingStartedPage2ButtonMessage.class, GettingStartedPage2ButtonMessage::buffer, GettingStartedPage2ButtonMessage::new, GettingStartedPage2ButtonMessage::handler);
    }
}

