/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unearthedjourney.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class RestingGoal
extends Goal {
    private final PathfinderMob entity;
    private final RestingAnimatable animatable;
    private final int maxDurationTicks;
    private int restingDurationTicks;
    private int elapsedTicks;
    private int lastHurtTimestamp;

    public RestingGoal(PathfinderMob entity, RestingAnimatable animatable, int maxDurationTicks) {
        this.entity = entity;
        this.animatable = animatable;
        this.maxDurationTicks = Math.max(600, maxDurationTicks);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.entity.m_217043_().m_188503_(1200) == 0 && this.entity.m_20184_().m_82556_() < 0.01 && this.entity.m_5448_() == null;
    }

    public void m_8056_() {
        this.restingDurationTicks = 600 + this.entity.m_217043_().m_188503_(this.maxDurationTicks - 600 + 1);
        this.elapsedTicks = 0;
        this.lastHurtTimestamp = this.entity.m_21213_();
        this.animatable.setResting(true);
        this.entity.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.animatable.setResting(false);
    }

    public void m_8037_() {
        ++this.elapsedTicks;
        this.entity.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        boolean wasHurt = this.entity.m_21213_() != this.lastHurtTimestamp;
        return this.elapsedTicks < this.restingDurationTicks && !wasHurt;
    }

    public static interface RestingAnimatable {
        public void setResting(boolean var1);

        public boolean isResting();
    }
}

