/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.render.book.component;

import bagu_chan.bagus_lib.client.render.book.BookAccess;
import bagu_chan.bagus_lib.client.render.book.component.BookComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class TextBookComponent
extends BookComponent {
    private final Component text;
    private final boolean mustEndAtEvenPage;
    private final List<FormattedCharSequence> cachedComponents = new ArrayList<FormattedCharSequence>();

    public TextBookComponent(Component text, int width, int height) {
        this(text, true, width, height);
    }

    public TextBookComponent(Component text, boolean mustEndAtEvenPage, int width, int height) {
        super(width, height);
        this.text = text;
        this.mustEndAtEvenPage = mustEndAtEvenPage;
    }

    @Override
    public int getPageCount(int pagesBefore, Font font) {
        int pageCount;
        if (this.cachedComponents.isEmpty()) {
            this.cachedComponents.addAll(font.m_92923_((FormattedText)this.text, this.width));
        }
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        int n = pageCount = this.cachedComponents.size() % linesPerPage == 0 ? this.cachedComponents.size() / linesPerPage : this.cachedComponents.size() / linesPerPage + 1;
        return this.mustEndAtEvenPage ? (pageCount % 2 == 0 ? pageCount + pagesBefore % 2 : pageCount + (1 - pagesBefore % 2)) : pageCount;
    }

    @Override
    public void render(BookAccess access, GuiGraphics graphics, Font font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        for (int i = access.getRelativePage() * linesPerPage; i < Math.min((access.getRelativePage() + 1) * linesPerPage, this.cachedComponents.size()); ++i) {
            int n = i - access.getRelativePage() * linesPerPage;
            Objects.requireNonNull(font);
            int textY = n * 9;
            graphics.m_280649_(font, this.cachedComponents.get(i), x, y + textY, 0, false);
        }
    }

    @Override
    public void tick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
    }

    @Override
    public void onClick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
    }
}

