/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.modcompat;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.items.NDUFoods;
import com.scouter.netherdepthsupgrade.modcompat.ModChecker;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class InfernalExpansionCompat {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public static Optional<Holder<MobEffect>> LUMINOUS;
    private static ResourceLocation LUMINOUS_RL;
    public static final FoodProperties GLOWDINE_IE;

    public static void setupCompatPreInit() {
        LOGGER.info("Setting up compat for Infernal Expansion");
        ModChecker.infernalExpansionPresent = true;
    }

    public static void setupCompatCommonSetup() {
        LOGGER.info("Setting up common setup compat for Infernal Expansion");
        LUMINOUS = ForgeRegistries.MOB_EFFECTS.getHolder(LUMINOUS_RL);
    }

    public static final Supplier<FoodProperties> getGlowdineFood() {
        if (ModChecker.infernalExpansionPresent) {
            return () -> GLOWDINE_IE;
        }
        return () -> NDUFoods.GLOWDINE;
    }

    static {
        LUMINOUS_RL = new ResourceLocation("infernalexp", "luminous");
        GLOWDINE_IE = new FoodProperties.Builder().m_38760_(1).m_38758_(0.5f).effect(() -> new MobEffectInstance(MobEffects.f_19619_, 1000, 0), 0.9f).effect(() -> new MobEffectInstance((MobEffect)LUMINOUS.get().m_203334_(), 1000, 0), 0.9f).effect(() -> new MobEffectInstance(MobEffects.f_19613_, 1000, 0), 0.7f).effect(() -> new MobEffectInstance(MobEffects.f_19596_, 800, 1), 0.5f).m_38767_();
    }
}

