/*
 * Decompiled with CFR 0.152.
 */
package filthycoin.theorcs.common.entities.state_machines.states;

import filthycoin.theorcs.common.entities.state_machines.BaseState;
import filthycoin.theorcs.common.entities.state_machines.StateMachine;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class PotionThrowState
extends BaseState {
    public Potion potion;
    public int delay;

    public PotionThrowState(Potion potion, int delay) {
        this.potion = potion;
        this.delay = delay;
    }

    @Override
    public void Start(StateMachine machine) {
        machine.entity.SetAnimation("throwing");
    }

    @Override
    public void Update(StateMachine machine) {
        if (machine.entity.m_5448_() != null) {
            machine.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, machine.entity.m_5448_().m_146892_());
        }
        if (machine.GetParameter("time_in_state").get().floatValue() == (float)this.delay) {
            LivingEntity target = machine.entity.m_5448_();
            Vec3 vec3 = target.m_20184_();
            double d0 = target.m_20185_() + vec3.f_82479_ - machine.entity.m_20185_();
            double d1 = target.m_20188_() - (double)1.1f - machine.entity.m_20186_();
            double d2 = target.m_20189_() + vec3.f_82481_ - machine.entity.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            ThrownPotion thrownpotion = new ThrownPotion(target.m_9236_(), (LivingEntity)machine.entity);
            thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)this.potion));
            thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
            thrownpotion.m_146884_(machine.entity.m_146892_());
            thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            machine.entity.m_9236_().m_7967_((Entity)thrownpotion);
        }
    }

    @Override
    public void TimeLimitReached(StateMachine machine) {
        machine.SetParameter("throwing", 0.0f);
    }

    @Override
    public void End(StateMachine machine) {
    }
}

