/*
 * Decompiled with CFR 0.152.
 */
package filthycoin.theorcs.common.entities;

import filthycoin.theorcs.common.entities.state_machines.StateMachine;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BaseModEntity
extends PathfinderMob
implements GeoEntity,
Enemy {
    public final StateMachine stateMachine;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public HashMap<String, RawAnimation> animations = new HashMap();
    protected String current_animation = "idle";
    protected RawAnimation next_anim_builder = null;
    protected RawAnimation current_anim_builder = null;
    public float melee_attack_range = 1.5f;
    public float aggro_radius = 24.0f;
    public float wandering_distance = 8.0f;
    public int wander_wait_time_range = 80;
    public Vec3 startPosition = this.m_20182_();
    private boolean spawned = false;
    public static final EntityDataAccessor<String> animation_name = SynchedEntityData.m_135353_(BaseModEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    protected BaseModEntity(EntityType<? extends PathfinderMob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.stateMachine = new StateMachine(this);
        this.stateMachine.AddParameter("aggro_timer", 0.0f);
        this.stateMachine.AddParameter("angry", 0.0f);
        this.stateMachine.AddParameter("chasing", 0.0f);
        this.stateMachine.AddParameter("attacking", 0.0f);
        this.stateMachine.AddParameter("attacking_heavy", 0.0f);
        this.stateMachine.AddParameter("throwing", 0.0f);
        this.stateMachine.AddParameter("shooting", 0.0f);
        this.stateMachine.AddParameter("shooting_heavy", 0.0f);
        this.m_274367_(1.0f);
    }

    public static boolean checkCanSpawnHostile(EntityType<? extends BaseModEntity> p_33024_, LevelAccessor p_33025_, MobSpawnType p_33026_, BlockPos p_33027_, Random p_33028_) {
        return p_33025_.m_46791_() != Difficulty.PEACEFUL;
    }

    public RawAnimation getCurrentAnimation() {
        if (this.next_anim_builder != null && this.next_anim_builder != this.current_anim_builder) {
            this.current_anim_builder = this.next_anim_builder;
        }
        return this.current_anim_builder;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean HasAnimation(String animation) {
        return this.animations.containsKey(animation);
    }

    public void SetAnimation(String animation) {
        this.current_animation = animation;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(animation_name, (Object)"idle");
    }

    public boolean IsWithinAttackRadius(LivingEntity target) {
        return this.IsWithinAttackRadius(target, 1.0f);
    }

    public boolean IsWithinAttackRadius(LivingEntity target, float modifier) {
        Player player;
        if (target == null) {
            return false;
        }
        if (this.m_20270_((Entity)target) > this.aggro_radius * modifier) {
            return false;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            return false;
        }
        return !target.m_21224_();
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.spawned) {
            this.spawned = true;
            this.startPosition = this.m_20182_();
        } else if (this.m_20182_().m_82554_(this.startPosition) > (double)(this.wandering_distance * 2.0f)) {
            this.startPosition = this.m_20182_();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5448_() instanceof BaseModEntity) {
                this.m_6710_(null);
            }
            this.stateMachine.Update();
            this.f_19804_.m_135381_(animation_name, (Object)this.current_animation);
        } else {
            this.current_animation = (String)this.f_19804_.m_135370_(animation_name);
            if (this.HasAnimation(this.current_animation)) {
                this.next_anim_builder = this.animations.get(this.current_animation);
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("StartPosX", this.startPosition.f_82479_);
        tag.m_128347_("StartPosY", this.startPosition.f_82480_);
        tag.m_128347_("StartPosZ", this.startPosition.f_82481_);
        tag.m_128379_("HasSpawned", this.spawned);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.startPosition = new Vec3(tag.m_128459_("StartPosX"), tag.m_128459_("StartPosY"), tag.m_128459_("StartPosZ"));
        this.spawned = tag.m_128471_("HasSpawned");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, state -> state.setAndContinue(this.getCurrentAnimation()))});
    }
}

