/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.blowguns.platform.services;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public String getGameDirectory();

    public boolean isClientSide();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public CreativeModeTab.Builder createTabBuilder();

    public <T extends Entity> EntityType.Builder<T> createEntityType(BiFunction<EntityType<T>, Level, T> var1, MobCategory var2);

    public <E extends Entity, T extends EntityType<E>, R extends EntityRenderer<E>> void registerEntityRenderer(T var1, Function<EntityRendererProvider.Context, R> var2);

    public void registerTippedDartItemColoring();

    public void registerTippedDartRecipeSerializer();

    default public boolean additionalSlotToCheck() {
        return this.isModLoaded("trinkets") || this.isModLoaded("curios");
    }

    public boolean hasDartPouchInAdditionalSlot(LivingEntity var1);

    public ItemStack getDartFromAdditionalSlot(LivingEntity var1);

    public void removeDartFromAdditionalSlot(LivingEntity var1);
}

