/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.blowguns;

import forge.com.cursee.blowguns.BlowgunsClient;
import forge.com.cursee.blowguns.client.model.DartPouchModel;
import forge.com.cursee.blowguns.client.renderer.entity.layers.DartPouchRenderLayer;
import forge.com.cursee.blowguns.core.compat.ForgeCuriosHelper;
import forge.com.cursee.blowguns.platform.Services;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class BlowgunsClientForge {
    public BlowgunsClientForge(IEventBus modEventBus) {
        BlowgunsClient.init();
        modEventBus.addListener(event -> {
            BlowgunsClient.setup();
            event.enqueueWork(() -> {
                if (Services.PLATFORM.additionalSlotToCheck()) {
                    ForgeCuriosHelper.registerRenderersForCurios();
                }
            });
        });
        modEventBus.addListener(event -> event.registerLayerDefinition(DartPouchModel.LAYER_LOCATION, DartPouchModel::createBodyLayer));
        modEventBus.addListener(event -> {
            BlowgunsClientForge.addLayerToPlayerSkin(event, "default", DartPouchRenderLayer::new);
            BlowgunsClientForge.addLayerToPlayerSkin(event, "slim", DartPouchRenderLayer::new);
        });
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }
}

