/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.blowguns.platform;

import dev.emi.trinkets.api.TrinketsApi;
import fabric.com.cursee.blowguns.Blowguns;
import fabric.com.cursee.blowguns.core.registry.ModItems;
import fabric.com.cursee.blowguns.core.world.item.DartPouchItem;
import fabric.com.cursee.blowguns.core.world.item.crafting.TippedDartRecipe;
import fabric.com.cursee.blowguns.platform.services.IPlatformHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5617;
import net.minecraft.class_7923;
import net.minecraft.class_897;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public String getGameDirectory() {
        return FabricLoader.getInstance().getGameDir().toString();
    }

    @Override
    public boolean isClientSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public class_1761.class_7913 createTabBuilder() {
        return FabricItemGroup.builder();
    }

    @Override
    public <T extends class_1297> class_1299.class_1300<T> createEntityType(BiFunction<class_1299<T>, class_1937, T> constructor, class_1311 category) {
        return class_1299.class_1300.method_5903(constructor::apply, (class_1311)category);
    }

    @Override
    public <E extends class_1297, T extends class_1299<E>, R extends class_897<E>> void registerEntityRenderer(T entityType, Function<class_5617.class_5618, R> entityRendererConstructor) {
        EntityRendererRegistry.register(entityType, entityRendererConstructor::apply);
    }

    @Override
    public void registerTippedDartItemColoring() {
        ColorProviderRegistry.ITEM.register((itemStack, color) -> color == 0 ? class_1844.method_8064((class_1799)itemStack) : -1, (Object[])new class_1935[]{ModItems.TIPPED_DART});
    }

    @Override
    public void registerTippedDartRecipeSerializer() {
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Blowguns.identifier("crafting_special_tipped_dart"), (Object)new class_1866(TippedDartRecipe::new));
    }

    @Override
    public class_1799 getDartFromAdditionalSlot(class_1309 entity) {
        AtomicReference<class_1799> atomicCopy = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(component -> {
            class_1799 pouchStack = (class_1799)((class_3545)component.getAllEquipped().get(0)).method_15441();
            if (pouchStack.method_7909() instanceof DartPouchItem) {
                Optional<class_1799> optional = DartPouchItem.removeOne(pouchStack);
                optional.ifPresent(atomicCopy::set);
                DartPouchItem.add(pouchStack, (class_1799)atomicCopy.get());
            }
        });
        return atomicCopy.get();
    }

    @Override
    public void removeDartFromAdditionalSlot(class_1309 entity) {
        AtomicReference<class_1799> atomicCopy = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(component -> {
            if (((class_1799)((class_3545)component.getEquipped(ModItems.DART_POUCH).get(0)).method_15441()).method_7909() instanceof DartPouchItem) {
                Optional<class_1799> optional = DartPouchItem.removeOne((class_1799)((class_3545)component.getEquipped(ModItems.DART_POUCH).get(0)).method_15441());
                optional.ifPresent(stack -> {
                    block3: {
                        block2: {
                            if (!(entity instanceof class_1657)) break block2;
                            class_1657 player = (class_1657)entity;
                            if (player.method_31549().field_7477) break block3;
                        }
                        stack.method_7934(1);
                    }
                    atomicCopy.set((class_1799)stack);
                });
                DartPouchItem.add((class_1799)((class_3545)component.getEquipped(ModItems.DART_POUCH).get(0)).method_15441(), (class_1799)atomicCopy.get());
            }
        });
    }

    @Override
    public boolean hasDartPouchInAdditionalSlot(class_1309 entity) {
        AtomicBoolean foundPouch = new AtomicBoolean(false);
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(component -> {
            if (!component.getEquipped(ModItems.DART_POUCH).isEmpty()) {
                foundPouch.set(true);
            }
        });
        return foundPouch.get();
    }
}

