/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.blowguns.core.world.item;

import fabric.com.cursee.blowguns.core.registry.ModItems;
import fabric.com.cursee.blowguns.core.world.item.DartItem;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;

public class DartPouchItem
extends class_1792 {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 256;
    private static final int POUCH_IN_POUCH_WEIGHT = 4;
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);

    public DartPouchItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static float getFullnessDisplay(class_1799 stack) {
        return (float)DartPouchItem.getContentWeight(stack) / 256.0f;
    }

    public boolean method_31565(class_1799 pouchStack, class_1735 slot, class_5536 action, class_1657 player) {
        if (pouchStack.method_7947() == 1 && action == class_5536.field_27014) {
            class_1799 itemstack = slot.method_7677();
            if (itemstack.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                DartPouchItem.removeOne(pouchStack).ifPresent(itemStack -> DartPouchItem.add(pouchStack, slot.method_32756(itemStack)));
            } else if (itemstack.method_7909().method_31568()) {
                int i = (256 - DartPouchItem.getContentWeight(pouchStack)) / DartPouchItem.getWeight(itemstack);
                int j = DartPouchItem.add(pouchStack, slot.method_32753(itemstack.method_7947(), i, player));
                if (j > 0) {
                    this.playInsertSound((class_1297)player);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 pouchStack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (pouchStack.method_7947() != 1) {
            return false;
        }
        if (action == class_5536.field_27014 && slot.method_32754(player)) {
            if (other.method_7960()) {
                DartPouchItem.removeOne(pouchStack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((class_1297)player);
                    access.method_32332(itemStack);
                });
            } else {
                int i = DartPouchItem.add(pouchStack, other);
                if (i > 0) {
                    this.playInsertSound((class_1297)player);
                    other.method_7934(i);
                }
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemstack = player.method_5998(usedHand);
        if (DartPouchItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((class_1297)player);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemstack, (boolean)level.method_8608());
        }
        return class_1271.method_22431((Object)itemstack);
    }

    public boolean method_31567(class_1799 stack) {
        return DartPouchItem.getContentWeight(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + 12 * DartPouchItem.getContentWeight(stack) / 256, 13);
    }

    public int method_31571(class_1799 stack) {
        return BAR_COLOR;
    }

    public static int add(class_1799 bundleStack, class_1799 insertedStack) {
        if (!(insertedStack.method_7909() instanceof DartItem)) {
            return 0;
        }
        if (!insertedStack.method_7960() && insertedStack.method_7909().method_31568()) {
            class_2487 compoundtag = bundleStack.method_7948();
            if (!compoundtag.method_10545(TAG_ITEMS)) {
                compoundtag.method_10566(TAG_ITEMS, (class_2520)new class_2499());
            }
            int i = DartPouchItem.getContentWeight(bundleStack);
            int j = DartPouchItem.getWeight(insertedStack);
            int k = Math.min(insertedStack.method_7947(), (256 - i) / j);
            if (k == 0) {
                return 0;
            }
            class_2499 listtag = compoundtag.method_10554(TAG_ITEMS, 10);
            Optional<class_2487> optional = DartPouchItem.getMatchingItem(insertedStack, listtag);
            if (optional.isPresent()) {
                class_2487 compoundtag1 = optional.get();
                class_1799 itemstack = class_1799.method_7915((class_2487)compoundtag1);
                itemstack.method_7933(k);
                itemstack.method_7953(compoundtag1);
                listtag.remove((Object)compoundtag1);
                listtag.method_10531(0, (class_2520)compoundtag1);
            } else {
                class_1799 itemstack1 = insertedStack.method_46651(k);
                class_2487 compoundtag2 = new class_2487();
                itemstack1.method_7953(compoundtag2);
                listtag.method_10531(0, (class_2520)compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<class_2487> getMatchingItem(class_1799 stack, class_2499 list) {
        if (stack.method_7909() instanceof DartPouchItem) {
            return Optional.empty();
        }
        Stream<class_2520> tags = list.stream();
        tags = tags.filter(class_2487.class::isInstance);
        Optional<class_2487> optional = tags.map(class_2487.class::cast).filter(tag -> class_1799.method_31577((class_1799)class_1799.method_7915((class_2487)tag), (class_1799)stack)).findFirst();
        return optional;
    }

    private static int getWeight(class_1799 stack) {
        class_2487 compoundtag;
        if (stack.method_31574(ModItems.DART_POUCH)) {
            return 4 + DartPouchItem.getContentWeight(stack);
        }
        if ((stack.method_31574(class_1802.field_20416) || stack.method_31574(class_1802.field_20415)) && stack.method_7985() && (compoundtag = class_1747.method_38072((class_1799)stack)) != null && !compoundtag.method_10554("Bees", 10).isEmpty()) {
            return 256;
        }
        return 256 / stack.method_7914();
    }

    private static int getContentWeight(class_1799 stack) {
        return DartPouchItem.getContents(stack).mapToInt(itemStack -> DartPouchItem.getWeight(itemStack) * itemStack.method_7947()).sum();
    }

    public static Optional<class_1799> removeOne(class_1799 stack) {
        class_2487 compoundtag = stack.method_7948();
        if (!compoundtag.method_10545(TAG_ITEMS)) {
            return Optional.empty();
        }
        class_2499 listtag = compoundtag.method_10554(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        int i = 0;
        class_2487 compoundtag1 = listtag.method_10602(i);
        class_1799 itemstack = class_1799.method_7915((class_2487)compoundtag1);
        listtag.method_10536(i);
        if (listtag.isEmpty()) {
            stack.method_7983(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(class_1799 stack, class_1657 player) {
        class_2487 compoundtag = stack.method_7948();
        if (!compoundtag.method_10545(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof class_3222) {
            class_2499 listtag = compoundtag.method_10554(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                class_2487 compoundtag1 = listtag.method_10602(i);
                class_1799 itemstack = class_1799.method_7915((class_2487)compoundtag1);
                player.method_7328(itemstack, true);
            }
        }
        stack.method_7983(TAG_ITEMS);
        return true;
    }

    private static Stream<class_1799> getContents(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return Stream.empty();
        }
        class_2499 list = tag.method_10554(TAG_ITEMS, 10);
        Stream tagStream = list.stream();
        return tagStream.map(class_2487.class::cast).map(class_1799::method_7915);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 filledList = class_2371.method_10211();
        Stream<class_1799> stackContents = DartPouchItem.getContents(stack);
        stackContents.forEach(arg_0 -> filledList.add(arg_0));
        return Optional.of(new class_5631(filledList, DartPouchItem.getContentWeight(stack)));
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{DartPouchItem.getContentWeight(stack), 256}).method_27692(class_124.field_1080));
    }

    public void method_33261(class_1542 itemEntity) {
        class_5328.method_33263((class_1542)itemEntity, DartPouchItem.getContents(itemEntity.method_6983()));
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

