/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.blowguns.core.world.item;

import common.com.cursee.blowguns.core.registry.ModItems;
import common.com.cursee.blowguns.core.world.item.DartItem;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DartPouchItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 256;
    private static final int POUCH_IN_POUCH_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public DartPouchItem(Item.Properties properties) {
        super(properties);
    }

    public static float getFullnessDisplay(ItemStack stack) {
        return (float)DartPouchItem.getContentWeight(stack) / 256.0f;
    }

    public boolean m_142207_(ItemStack pouchStack, Slot slot, ClickAction action, Player player) {
        if (pouchStack.m_41613_() == 1 && action == ClickAction.SECONDARY) {
            ItemStack itemstack = slot.m_7993_();
            if (itemstack.m_41619_()) {
                this.playRemoveOneSound((Entity)player);
                DartPouchItem.removeOne(pouchStack).ifPresent(itemStack -> DartPouchItem.add(pouchStack, slot.m_150659_(itemStack)));
            } else if (itemstack.m_41720_().m_142095_()) {
                int i = (256 - DartPouchItem.getContentWeight(pouchStack)) / DartPouchItem.getWeight(itemstack);
                int j = DartPouchItem.add(pouchStack, slot.m_150647_(itemstack.m_41613_(), i, player));
                if (j > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack pouchStack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (pouchStack.m_41613_() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (other.m_41619_()) {
                DartPouchItem.removeOne(pouchStack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((Entity)player);
                    access.m_142104_(itemStack);
                });
            } else {
                int i = DartPouchItem.add(pouchStack, other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                    other.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        if (DartPouchItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_142522_(ItemStack stack) {
        return DartPouchItem.getContentWeight(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * DartPouchItem.getContentWeight(stack) / 256, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public static int add(ItemStack bundleStack, ItemStack insertedStack) {
        if (!(insertedStack.m_41720_() instanceof DartItem)) {
            return 0;
        }
        if (!insertedStack.m_41619_() && insertedStack.m_41720_().m_142095_()) {
            CompoundTag compoundtag = bundleStack.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = DartPouchItem.getContentWeight(bundleStack);
            int j = DartPouchItem.getWeight(insertedStack);
            int k = Math.min(insertedStack.m_41613_(), (256 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = DartPouchItem.getMatchingItem(insertedStack, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                itemstack.m_41769_(k);
                itemstack.m_41739_(compoundtag1);
                listtag.remove((Object)compoundtag1);
                listtag.add(0, (Tag)compoundtag1);
            } else {
                ItemStack itemstack1 = insertedStack.m_255036_(k);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.m_41739_(compoundtag2);
                listtag.add(0, (Tag)compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag list) {
        if (stack.m_41720_() instanceof DartPouchItem) {
            return Optional.empty();
        }
        Stream<Tag> tags = list.stream();
        tags = tags.filter(CompoundTag.class::isInstance);
        Optional<CompoundTag> optional = tags.map(CompoundTag.class::cast).filter(tag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)tag), (ItemStack)stack)).findFirst();
        return optional;
    }

    private static int getWeight(ItemStack stack) {
        CompoundTag compoundtag;
        if (stack.m_150930_(ModItems.DART_POUCH)) {
            return 4 + DartPouchItem.getContentWeight(stack);
        }
        if ((stack.m_150930_(Items.f_42786_) || stack.m_150930_(Items.f_42785_)) && stack.m_41782_() && (compoundtag = BlockItem.m_186336_((ItemStack)stack)) != null && !compoundtag.m_128437_("Bees", 10).isEmpty()) {
            return 256;
        }
        return 256 / stack.m_41741_();
    }

    private static int getContentWeight(ItemStack stack) {
        return DartPouchItem.getContents(stack).mapToInt(itemStack -> DartPouchItem.getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    public static Optional<ItemStack> removeOne(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        int i = 0;
        CompoundTag compoundtag1 = listtag.m_128728_(i);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(i);
        if (listtag.isEmpty()) {
            stack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                player.m_36176_(itemstack, true);
            }
        }
        stack.m_41749_(TAG_ITEMS);
        return true;
    }

    private static Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Stream.empty();
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        Stream tagStream = list.stream();
        return tagStream.map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList filledList = NonNullList.m_122779_();
        Stream<ItemStack> stackContents = DartPouchItem.getContents(stack);
        stackContents.forEach(arg_0 -> filledList.add(arg_0));
        return Optional.of(new BundleTooltip(filledList, DartPouchItem.getContentWeight(stack)));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{DartPouchItem.getContentWeight(stack), 256}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, DartPouchItem.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

