/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.blowguns.core.world.entity.projectile;

import com.google.common.collect.Sets;
import common.com.cursee.blowguns.core.registry.ModEntities;
import common.com.cursee.blowguns.core.registry.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class Dart
extends AbstractArrow {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(Dart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final byte EVENT_POTION_PUFF = 0;
    private Potion potion;
    private final Set<MobEffectInstance> effects;
    private boolean fixedColor;

    public Dart(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.m_36781_(1.0);
        this.potion = Potions.f_43598_;
        this.effects = Sets.newHashSet();
    }

    public Dart(double x, double y, double z, Level level) {
        super(ModEntities.DART, x, y, z, level);
        this.m_36781_(1.0);
        this.potion = Potions.f_43598_;
        this.effects = Sets.newHashSet();
    }

    public Dart(LivingEntity livingEntity, Level level) {
        super(ModEntities.DART, livingEntity, level);
        this.m_36781_(1.0);
        this.potion = Potions.f_43598_;
        this.effects = Sets.newHashSet();
    }

    public Dart(Level level, LivingEntity livingEntity) {
        this(livingEntity, level);
    }

    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)ModItems.DART);
        }
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.TIPPED_DART);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.potion != Potions.f_43598_) {
            compound.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)compound)) {
            this.addEffect(mobeffectinstance);
        }
        if (compound.m_128425_("Color", 99)) {
            this.setFixedColor(compound.m_128451_("Color"));
        } else {
            this.updateColor();
        }
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        Entity entity = this.m_150173_();
        for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
            living.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_267696_(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance1 : this.effects) {
                living.m_147207_(mobeffectinstance1, entity);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
        if (this.f_36703_ && this.f_36704_ >= 100) {
            this.m_146870_();
        }
    }

    public void m_7822_(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    private void makeParticle(int particleAmount) {
        int color = this.getColor();
        if (color != -1 && particleAmount > 0) {
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleAmount; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    public static int getCustomColor(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99) ? compoundtag.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    private void setFixedColor(int fixedColor) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)fixedColor);
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.effects.add(effectInstance);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    public void setEffectsFromItem(ItemStack stack) {
        if (stack.m_150930_(ModItems.TIPPED_DART)) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)stack);
            List collection = PotionUtils.m_43571_((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
            if ((i = Dart.getCustomColor(stack)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.m_150930_(ModItems.DART)) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
    }
}

