/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.creaking;

import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blockentities.CreakingHeartBlockEntity;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.blockstates.CreakingHeartState;
import com.blackgear.vanillabackport.common.level.entities.creaking.CreakingAi;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Creaking
extends Monster {
    private static final EntityDataAccessor<Boolean> CAN_MOVE = SynchedEntityData.m_135353_(Creaking.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(Creaking.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_TEARING_DOWN = SynchedEntityData.m_135353_(Creaking.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> HOME_POS = SynchedEntityData.m_135353_(Creaking.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public static final byte CREAKING_ATTACK = 4;
    public static final byte CREAKING_HURT = 66;
    private int attackAnimationRemainingTicks;
    private int invulnerabilityAnimationRemainingTicks;
    private boolean eyesGlowing;
    private int nextFlickerTime;
    private int playerStuckCounter;
    private int creakingDeathTime;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState invulnerabilityAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();

    public Creaking(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new CreakingLookControl((Mob)this);
        this.f_21342_ = new CreakingMoveControl((Mob)this);
        this.f_21343_ = new CreakingJumpControl((Mob)this);
        GroundPathNavigation navigation = (GroundPathNavigation)this.m_21573_();
        navigation.m_7008_(true);
        this.m_274367_(1.0625f);
        this.f_21364_ = 0;
    }

    public void setTransient(BlockPos pos) {
        this.setHomePos(pos);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 8.0f);
    }

    public boolean isHeartBound() {
        return this.getHomePos() != null;
    }

    protected BodyRotationControl m_7560_() {
        return new CreakingBodyRotationControl((Mob)this);
    }

    protected Brain.Provider<Creaking> m_5490_() {
        return CreakingAi.brainProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return CreakingAi.makeBrain((Brain<Creaking>)this.m_5490_().m_22073_(dynamic));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_MOVE, (Object)true);
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(IS_TEARING_DOWN, (Object)false);
        this.f_19804_.m_135372_(HOME_POS, Optional.empty());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public boolean canMove() {
        return (Boolean)this.f_19804_.m_135370_(CAN_MOVE);
    }

    public boolean m_7327_(Entity target) {
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 15;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(target);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        BlockPos home = this.getHomePos();
        if (home == null || source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (!this.m_6673_(source) && this.invulnerabilityAnimationRemainingTicks <= 0 && !this.m_21224_()) {
            Player player = this.blameSourceForDamage(source);
            Entity entity = source.m_7640_();
            if (entity instanceof LivingEntity || entity instanceof Projectile || player != null) {
                CreakingHeartBlockEntity heart;
                this.invulnerabilityAnimationRemainingTicks = 8;
                this.m_9236_().m_7605_((Entity)this, (byte)66);
                BlockEntity blockEntity = this.m_9236_().m_7702_(home);
                if (blockEntity instanceof CreakingHeartBlockEntity && (heart = (CreakingHeartBlockEntity)blockEntity).isProtector(this)) {
                    if (player != null) {
                        heart.creakingHurt();
                    }
                    this.m_6677_(source);
                }
                return true;
            }
        }
        return false;
    }

    public float m_20236_(Pose pose) {
        return 2.3f;
    }

    @Nullable
    public Player blameSourceForDamage(DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!source.m_269533_(DamageTypeTags.f_268718_)) {
                Wolf wolf;
                this.m_6703_(living);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.f_20889_ = 100;
                    this.f_20888_ = player;
                } else if (entity instanceof Wolf && (wolf = (Wolf)entity).m_21824_()) {
                    Player player;
                    this.f_20889_ = 100;
                    LivingEntity livingEntity = wolf.m_269323_();
                    this.f_20888_ = livingEntity instanceof Player ? (player = (Player)livingEntity) : null;
                }
            }
        }
        return this.f_20888_;
    }

    public boolean m_6094_() {
        return super.m_6094_() && this.canMove();
    }

    public void m_5997_(double x, double y, double z) {
        if (this.canMove()) {
            super.m_5997_(x, y, z);
        }
    }

    public Brain<Creaking> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("creakingBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        CreakingAi.updateActivity(this);
    }

    public void m_8107_() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if (!this.m_9236_().m_5776_()) {
            boolean canMove = (Boolean)this.f_19804_.m_135370_(CAN_MOVE);
            boolean checkCanMove = this.checkCanMove();
            if (checkCanMove != canMove) {
                if (checkCanMove) {
                    this.m_216990_(ModSoundEvents.CREAKING_UNFREEZE.get());
                } else {
                    this.m_21573_().m_26573_();
                    this.m_21570_(0.0f);
                    this.m_21567_(0.0f);
                    this.m_7910_(0.0f);
                    this.m_216990_(ModSoundEvents.CREAKING_FREEZE.get());
                }
            }
            this.f_19804_.m_135381_(CAN_MOVE, (Object)checkCanMove);
        }
        super.m_8107_();
    }

    public void m_8119_() {
        BlockPos pos;
        if (!this.m_9236_().m_5776_() && (pos = this.getHomePos()) != null) {
            CreakingHeartBlockEntity heart;
            boolean isProtector;
            BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
            boolean bl = isProtector = blockEntity instanceof CreakingHeartBlockEntity && (heart = (CreakingHeartBlockEntity)blockEntity).isProtector(this);
            if (!isProtector) {
                this.m_21153_(0.0f);
            }
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.isTearingDown() && this.f_20919_ != 0) {
                this.f_20919_ = 0;
            }
            this.setupAnimationStates();
            this.checkEyeBlink();
        }
    }

    protected void m_6153_() {
        if (this.isHeartBound() && this.isTearingDown()) {
            ++this.creakingDeathTime;
            if (!this.m_9236_().m_5776_() && this.creakingDeathTime > 45 && !this.m_213877_()) {
                this.tearDown();
            }
        } else {
            super.m_6153_();
        }
    }

    protected void m_267689_(float partialTick) {
        float speed = Math.min(partialTick * 25.0f, 3.0f);
        this.f_267362_.m_267566_(speed, 0.4f);
    }

    private void setupAnimationStates() {
        this.attackAnimationState.m_246184_(this.attackAnimationRemainingTicks > 0, this.f_19797_);
        this.invulnerabilityAnimationState.m_246184_(this.invulnerabilityAnimationRemainingTicks > 0, this.f_19797_);
        this.deathAnimationState.m_246184_(this.isTearingDown(), this.f_19797_);
    }

    public void tearDown() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            AABB aabb = this.m_20191_();
            Vec3 center = aabb.m_82399_();
            double x = aabb.m_82362_() * 0.3;
            double y = aabb.m_82376_() * 0.3;
            double z = aabb.m_82385_() * 0.3;
            ModParticles.sendParticles(server, new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.PALE_OAK_WOOD.get().m_49966_()), center.f_82479_, center.f_82480_, center.f_82481_, 100, x, y, z, 0.0);
            ModParticles.sendParticles(server, new BlockParticleOption(ParticleTypes.f_123794_, (BlockState)ModBlocks.CREAKING_HEART.get().m_49966_().m_61124_(CreakingHeartBlock.STATE, (Comparable)((Object)CreakingHeartState.AWAKE))), center.f_82479_, center.f_82480_, center.f_82481_, 10, x, y, z, 0.0);
        }
        this.m_216990_(this.m_5592_());
        this.m_146870_();
    }

    public void creakingDeathEffects(DamageSource source) {
        this.blameSourceForDamage(source);
        this.m_6667_(source);
        this.m_216990_(ModSoundEvents.CREAKING_TWITCH.get());
    }

    public void m_7822_(byte id) {
        if (id == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.m_6677_(this.m_269291_().m_269264_());
        } else if (id == 4) {
            this.attackAnimationRemainingTicks = 15;
            this.playAttackSound();
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_5825_() {
        return this.isHeartBound() || super.m_5825_();
    }

    protected boolean m_7310_(Entity passenger) {
        return !this.isHeartBound() && super.m_7310_(passenger);
    }

    protected boolean m_269011_() {
        return !this.isHeartBound() && super.m_269011_();
    }

    protected void m_20348_(Entity passenger) {
        if (!this.isHeartBound()) {
            super.m_20348_(passenger);
        }
    }

    public void m_20221_(BlockPos pos) {
        if (!this.isHeartBound()) {
            super.m_20221_(pos);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new CreakingPathNavigation(this, level);
    }

    public boolean playerIsStuckInYou() {
        List players = this.f_20939_.m_21952_(MemoryModuleType.f_26367_).orElse(List.of());
        if (!players.isEmpty()) {
            AABB aabb = this.m_20191_();
            for (Player player : players) {
                if (!aabb.m_82390_(player.m_146892_())) continue;
                ++this.playerStuckCounter;
                return this.playerStuckCounter > 4;
            }
        }
        this.playerStuckCounter = 0;
        return false;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("home_pos")) {
            this.setTransient(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("home_pos")));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getHomePos() != null) {
            tag.m_128365_("home_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.getHomePos()));
        }
    }

    public void setHomePos(BlockPos pos) {
        this.f_19804_.m_135381_(HOME_POS, Optional.of(pos));
    }

    public BlockPos getHomePos() {
        return ((Optional)this.f_19804_.m_135370_(HOME_POS)).orElse(null);
    }

    public void setTearingDown() {
        this.f_19804_.m_135381_(IS_TEARING_DOWN, (Object)true);
    }

    public boolean isTearingDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_TEARING_DOWN);
    }

    public boolean hasGlowingEyes() {
        return this.eyesGlowing;
    }

    public void checkEyeBlink() {
        if (this.creakingDeathTime > this.nextFlickerTime) {
            this.nextFlickerTime = this.creakingDeathTime + this.m_217043_().m_216332_(this.eyesGlowing ? 2 : this.creakingDeathTime / 4, this.eyesGlowing ? 8 : this.creakingDeathTime / 2);
            this.eyesGlowing = !this.eyesGlowing;
        }
    }

    public void playAttackSound() {
        this.m_216990_(ModSoundEvents.CREAKING_ATTACK.get());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isActive() ? null : ModSoundEvents.CREAKING_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.isHeartBound() ? ModSoundEvents.CREAKING_SWAY.get() : super.m_7975_(source);
    }

    protected SoundEvent m_5592_() {
        return ModSoundEvents.CREAKING_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSoundEvents.CREAKING_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public void m_147240_(double strength, double x, double z) {
        if (this.canMove()) {
            super.m_147240_(strength, x, z);
        }
    }

    public boolean checkCanMove() {
        List players = this.f_20939_.m_21952_(MemoryModuleType.f_26367_).orElse(List.of());
        boolean isActive = this.isActive();
        if (players.isEmpty()) {
            if (isActive) {
                this.deactivate();
            }
        } else {
            boolean canMove = false;
            for (Player player : players) {
                if (!this.m_6779_((LivingEntity)player) || this.m_7307_((Entity)player)) continue;
                canMove = true;
                if (isActive && player.m_6844_(EquipmentSlot.HEAD).m_150930_(Blocks.f_50143_.m_5456_()) || !this.isLookingAtMe((LivingEntity)player, 0.5, false, true, this.m_20188_(), this.m_20186_() + 0.5 * (double)this.m_6134_(), (this.m_20188_() + this.m_20186_()) / 2.0)) continue;
                if (isActive) {
                    return false;
                }
                if (!(player.m_20280_((Entity)this) < 144.0)) continue;
                this.activate(player);
                return false;
            }
            if (!canMove && isActive) {
                this.deactivate();
            }
        }
        return true;
    }

    public boolean isLookingAtMe(LivingEntity entity, double tolerance, boolean scaleWithDistance, boolean checkVisibility, double ... heightTargets) {
        Vec3 viewVector = entity.m_20252_(1.0f).m_82541_();
        for (double heightTarget : heightTargets) {
            double lookThreshold;
            Vec3 directionToMe = new Vec3(this.m_20185_() - entity.m_20185_(), heightTarget - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
            double distance = directionToMe.m_82553_();
            double dotProduct = viewVector.m_82526_(directionToMe = directionToMe.m_82541_());
            if (!(dotProduct > (lookThreshold = 1.0 - tolerance / (scaleWithDistance ? distance : 1.0))) || !this.hasLineOfSight(entity, (Entity)this, checkVisibility ? ClipContext.Block.VISUAL : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, heightTarget)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLineOfSight(LivingEntity stalker, Entity me, ClipContext.Block block, ClipContext.Fluid fluid, double targetHeight) {
        if (me.m_9236_() != stalker.m_9236_()) {
            return false;
        }
        Vec3 stalkerPosition = new Vec3(stalker.m_20185_(), stalker.m_20188_(), stalker.m_20189_());
        Vec3 myPosition = new Vec3(me.m_20185_(), targetHeight, me.m_20189_());
        return myPosition.m_82554_(stalkerPosition) <= 128.0 && stalker.m_9236_().m_45547_(new ClipContext(stalkerPosition, myPosition, block, fluid, (Entity)stalker)).m_6662_() == HitResult.Type.MISS;
    }

    public void activate(Player player) {
        this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)player);
        this.m_216990_(ModSoundEvents.CREAKING_ACTIVATE.get());
        this.setIsActive(true);
    }

    public void deactivate() {
        this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        this.m_216990_(ModSoundEvents.CREAKING_DEACTIVATE.get());
        this.setIsActive(false);
    }

    public void setIsActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    class CreakingLookControl
    extends LookControl {
        public CreakingLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            if (Creaking.this.canMove()) {
                super.m_8128_();
            }
        }
    }

    class CreakingMoveControl
    extends MoveControl {
        public CreakingMoveControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (Creaking.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class CreakingJumpControl
    extends JumpControl {
        public CreakingJumpControl(Mob mob) {
            super(mob);
        }

        public void m_8124_() {
            if (Creaking.this.canMove()) {
                super.m_8124_();
            } else {
                Creaking.this.m_6862_(false);
            }
        }
    }

    class CreakingBodyRotationControl
    extends BodyRotationControl {
        public CreakingBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            if (Creaking.this.canMove()) {
                super.m_8121_();
            }
        }
    }

    class CreakingPathNavigation
    extends GroundPathNavigation {
        CreakingPathNavigation(Creaking creaking2, Level level) {
            super((Mob)creaking2, level);
        }

        public void m_7638_() {
            if (Creaking.this.canMove()) {
                super.m_7638_();
            }
        }

        protected PathFinder m_5532_(int i) {
            this.f_26508_ = new HomeNodeEvaluator();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, i);
        }
    }

    class HomeNodeEvaluator
    extends WalkNodeEvaluator {
        HomeNodeEvaluator() {
        }

        public BlockPathTypes m_8086_(BlockGetter level, int x, int y, int z) {
            BlockPos pos = Creaking.this.getHomePos();
            if (pos == null) {
                return super.m_8086_(level, x, y, z);
            }
            double distance = pos.m_123331_(new Vec3i(x, y, z));
            return distance > 1024.0 && distance >= pos.m_123331_((Vec3i)Creaking.this.m_20183_()) ? BlockPathTypes.BLOCKED : super.m_8086_(level, x, y, z);
        }
    }
}

