/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.illagerinvasion.world.entity.monster.Inquisitor;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.Items;

public class ArmoredIllagerEntityModel<T extends AbstractIllager>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private static final String LEFT_SHOULDERPAD = "left_shoulderpad";
    private static final String RIGHT_SHOULDERPAD = "right_shoulderpad";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart arms;
    private final ModelPart body;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart leftShoulderpad;
    private final ModelPart rightShoulderpad;

    public ArmoredIllagerEntityModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.body = root.m_171324_("body");
        this.hat.f_104207_ = false;
        this.arms = root.m_171324_("arms");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
        this.rightShoulderpad = root.m_171324_(RIGHT_SHOULDERPAD);
        this.leftShoulderpad = root.m_171324_(LEFT_SHOULDERPAD);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData2 = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData2.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.f_171404_);
        modelPartData2.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData3 = modelPartData.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        modelPartData3.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.f_171404_);
        modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        modelPartData.m_171599_(LEFT_SHOULDERPAD, CubeListBuilder.m_171558_().m_171514_(0, 64).m_171480_().m_171488_(-0.7f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(1.1f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        modelPartData.m_171599_(RIGHT_SHOULDERPAD, CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-3.3f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(1.1f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)128);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.rightArm.f_104203_ = -0.62831855f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -0.62831855f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
            this.rightShoulderpad.f_104203_ = -0.62831855f;
            this.leftShoulderpad.f_104203_ = -0.62831855f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightShoulderpad.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightShoulderpad.f_104204_ = 0.0f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftShoulderpad.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftShoulderpad.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.rightLeg.f_104204_ = 0.0f;
            this.rightLeg.f_104205_ = 0.0f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.leftLeg.f_104204_ = 0.0f;
            this.leftLeg.f_104205_ = 0.0f;
        }
        AbstractIllager.IllagerArmPose state = entity.m_6768_();
        HumanoidArm mainArm = entity.m_5737_();
        boolean hasShield = entity.m_21206_().m_150930_(Items.f_42740_);
        if (state == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entity.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
                AnimationUtils.m_102102_((ModelPart)this.leftShoulderpad, (ModelPart)this.rightShoulderpad, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.rightArm, (ModelPart)this.leftArm, entity, (float)this.f_102608_, (float)ageInTicks);
                AnimationUtils.m_102091_((ModelPart)this.rightShoulderpad, (ModelPart)this.leftShoulderpad, entity, (float)this.f_102608_, (float)ageInTicks);
            }
            if (hasShield && mainArm == HumanoidArm.RIGHT) {
                this.leftArm.f_104203_ = -1.05f;
                this.leftArm.f_104204_ = 0.5235988f;
                this.leftShoulderpad.f_104203_ = -1.05f;
                this.leftShoulderpad.f_104204_ = 0.5235988f;
            }
            if (hasShield && mainArm == HumanoidArm.LEFT) {
                this.rightArm.f_104203_ = 200.0f;
                this.rightArm.f_104204_ = -0.5235988f;
                this.rightShoulderpad.f_104203_ = 200.0f;
                this.rightShoulderpad.f_104204_ = -0.5235988f;
            }
            if (((Inquisitor)((Object)entity)).getStunnedState()) {
                this.head.f_104203_ = 18.5f;
                this.head.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.8f)) * 0.3f;
                this.rightArm.f_104203_ = 200.0f;
                this.rightArm.f_104204_ = 0.5235988f;
                this.rightShoulderpad.f_104203_ = 200.0f;
                this.rightShoulderpad.f_104204_ = 0.5235988f;
                this.leftArm.f_104203_ = 200.0f;
                this.leftArm.f_104204_ = -0.5235988f;
                this.leftShoulderpad.f_104203_ = 200.0f;
                this.leftShoulderpad.f_104204_ = -0.5235988f;
            }
        } else if (state == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.rightArm.f_104205_ = 2.3561945f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
        } else if (state == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.rightArm.f_104204_ = -0.1f + this.head.f_104204_;
            this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
            this.leftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
            this.leftArm.f_104204_ = this.head.f_104204_ - 0.4f;
            this.leftArm.f_104205_ = 1.5707964f;
        } else if (state == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
        } else if (state == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, entity, (boolean)true);
        } else if (state == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.rightArm.f_104205_ = 2.670354f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightShoulderpad.f_104202_ = 0.0f;
            this.rightShoulderpad.f_104200_ = -5.0f;
            this.rightShoulderpad.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.rightShoulderpad.f_104205_ = 2.670354f;
            this.rightShoulderpad.f_104204_ = 0.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftShoulderpad.f_104202_ = 0.0f;
            this.leftShoulderpad.f_104200_ = 5.0f;
            this.leftShoulderpad.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.leftShoulderpad.f_104205_ = -2.3561945f;
            this.leftShoulderpad.f_104204_ = 0.0f;
        }
        this.arms.f_104207_ = state == AbstractIllager.IllagerArmPose.CROSSED;
        boolean bl = this.arms.f_104207_;
        this.leftArm.f_104207_ = !bl;
        this.rightArm.f_104207_ = !bl;
    }

    private ModelPart getAttackingArm(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return this.leftArm;
        }
        return this.rightArm;
    }

    public ModelPart getHat() {
        return this.hat;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm arm, PoseStack matrices) {
        this.getAttackingArm(arm).m_104299_(matrices);
    }
}

