/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.night.better_sword_trims.component.ModDataComponents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTrimRecipe.class})
public class SmithingTrimRecipeMixin {
    @Inject(method={"assemble"}, at={@At(value="RETURN")}, cancellable=true)
    private void onAssemble(Container container, RegistryAccess registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        String trimMaterial;
        ItemStack result = (ItemStack)cir.getReturnValue();
        ItemStack template = container.m_8020_(0);
        ItemStack base = container.m_8020_(1);
        ItemStack addition = container.m_8020_(2);
        if (!result.m_41619_() && this.better_sword_trims$isSword(result) && !template.m_41619_() && template.m_41720_().toString().contains("spike_armor_trim_smithing_template") && (trimMaterial = this.better_sword_trims$getTrimMaterialFromItem(addition)) != null) {
            ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(trimMaterial);
            ModDataComponents.setTrim(result, trimComponent);
            cir.setReturnValue((Object)result);
        }
    }

    @Unique
    private boolean better_sword_trims$isSword(ItemStack stack) {
        return stack.m_41720_() == Items.f_42383_ || stack.m_41720_() == Items.f_42430_ || stack.m_41720_() == Items.f_42388_ || stack.m_41720_() == Items.f_42393_;
    }

    @Unique
    private String better_sword_trims$getTrimMaterialFromItem(ItemStack item) {
        if (item.m_41619_()) {
            return null;
        }
        if (item.m_150930_(Items.f_151052_)) {
            return "minecraft:copper_ingot";
        }
        if (item.m_150930_(Items.f_42616_)) {
            return "minecraft:emerald";
        }
        if (item.m_150930_(Items.f_42534_)) {
            return "minecraft:lapis_lazuli";
        }
        if (item.m_150930_(Items.f_42692_)) {
            return "minecraft:quartz";
        }
        if (item.m_150930_(Items.f_42451_)) {
            return "minecraft:redstone";
        }
        if (item.m_150930_(Items.f_42754_)) {
            return "minecraft:crying_obsidian";
        }
        return null;
    }
}

