/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.world.item.ItemStack;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getMaxDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyMaxDamage(CallbackInfoReturnable<Integer> cir) {
        String swordType;
        ModDataComponents.SwordTrimComponent trim;
        ItemStack stack = (ItemStack)this;
        if (stack.m_41720_().toString().contains("sword") && (trim = ModDataComponents.getTrim(stack)) != null && "minecraft:copper_ingot".equals(trim.getIngredient()) && (swordType = this.better_sword_trims$getSwordType(stack)) != null) {
            String configKey = swordType + "_copper";
            SwordConfig cfg = ConfigManager.getConfig(configKey);
            int originalMaxDamage = (Integer)cir.getReturnValue();
            int newMaxDamage = (int)((double)originalMaxDamage * cfg.durabilityMultiplier);
            cir.setReturnValue((Object)newMaxDamage);
        }
    }

    @Unique
    private String better_sword_trims$getSwordType(ItemStack stack) {
        String itemString = stack.m_41720_().toString();
        if (itemString.contains("netherite_sword")) {
            return "netherite";
        }
        if (itemString.contains("diamond_sword")) {
            return "diamond";
        }
        if (itemString.contains("golden_sword")) {
            return "golden";
        }
        if (itemString.contains("iron_sword")) {
            return "iron";
        }
        return null;
    }
}

