/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ModDataComponents {
    private static final String TRIM_TAG = "BetterSwordTrim";
    private static final String INGREDIENT_TAG = "ingredient";

    public static SwordTrimComponent getTrim(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TRIM_TAG)) {
            CompoundTag trimTag = tag.m_128469_(TRIM_TAG);
            String ingredient = trimTag.m_128461_(INGREDIENT_TAG);
            return new SwordTrimComponent(ingredient);
        }
        return null;
    }

    public static void setTrim(ItemStack stack, SwordTrimComponent component) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag trimTag = new CompoundTag();
        trimTag.m_128359_(INGREDIENT_TAG, component.getIngredient());
        tag.m_128365_(TRIM_TAG, (Tag)trimTag);
    }

    public static boolean hasTrim(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TRIM_TAG);
    }

    public static void removeTrim(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(TRIM_TAG);
        }
    }

    public static class SwordTrimComponent {
        public static final Codec<SwordTrimComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(ModDataComponents.INGREDIENT_TAG).forGetter(c -> c.ingredient)).apply((Applicative)instance, SwordTrimComponent::new));
        private final String ingredient;

        public SwordTrimComponent(String ingredient) {
            this.ingredient = ingredient;
        }

        public String getIngredient() {
            return this.ingredient;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SwordTrimComponent)) {
                return false;
            }
            SwordTrimComponent other = (SwordTrimComponent)obj;
            return this.ingredient.equals(other.ingredient);
        }

        public int hashCode() {
            return this.ingredient.hashCode();
        }
    }
}

