/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.danger_close;

import forge.com.cursee.danger_close.core.CommonConfigValues;
import forge.com.cursee.danger_close.core.optional.SoulFired;
import forge.com.cursee.danger_close.platform.Services;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DangerClose {
    public static final TagKey<Block> TORCH_BURN_DANGER = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("danger_close", "torch_burn_danger"));
    public static final TagKey<Block> SOUL_TORCH_BURN_DANGER = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("danger_close", "soul_torch_burn_danger"));
    public static final TagKey<Block> CAMPFIRE_BURN_DANGER = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("danger_close", "campfire_burn_danger"));
    public static final TagKey<Block> SOUL_CAMPFIRE_BURN_DANGER = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("danger_close", "soul_campfire_burn_danger"));
    public static final TagKey<Block> MAGMA_BURN_DANGER = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("danger_close", "magma_burn_danger"));
    public static final TagKey<Block> STONECUTTER_DANGER = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("danger_close", "stonecutter_danger"));
    public static final Predicate<TagKey<Block>> TORCH_MATCH = tag -> tag == TORCH_BURN_DANGER;
    public static final Predicate<TagKey<Block>> SOUL_TORCH_MATCH = tag -> tag == SOUL_TORCH_BURN_DANGER;
    public static final Predicate<TagKey<Block>> CAMPFIRE_MATCH = tag -> tag == CAMPFIRE_BURN_DANGER;
    public static final Predicate<TagKey<Block>> SOUL_CAMPFIRE_MATCH = tag -> tag == SOUL_CAMPFIRE_BURN_DANGER;
    public static final Predicate<TagKey<Block>> MAGMA_MATCH = tag -> tag == MAGMA_BURN_DANGER;
    public static final Predicate<TagKey<Block>> STONECUTTER_MATCH = tag -> tag == STONECUTTER_DANGER;
    public static boolean isSoulFiredLoaded = false;

    public static void init() {
        isSoulFiredLoaded = Services.PLATFORM.isModLoaded("soul_fire_d");
    }

    public static ResourceLocation identifier(String value) {
        return new ResourceLocation("danger_close", value);
    }

    public static void detect(LivingEntity entity) {
        if (!CommonConfigValues.shouldDetect) {
            return;
        }
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (entity.m_20096_()) {
            BlockPos pos = entity.m_20183_();
            BlockState stateInside = level.m_8055_(pos);
            BlockState stateBelow = level.m_8055_(pos.m_7495_());
            boolean hasFrostWalker = EnchantmentHelper.m_44938_((LivingEntity)entity);
            if (CommonConfigValues.shouldTorchImmolate && !hasFrostWalker) {
                if (stateInside.m_204343_().anyMatch(TORCH_MATCH)) {
                    DangerClose.immolate(entity);
                } else if (stateBelow.m_204343_().anyMatch(TORCH_MATCH)) {
                    DangerClose.immolate(entity);
                }
            }
            if (CommonConfigValues.shouldSoulTorchImmolate && !hasFrostWalker) {
                if (stateInside.m_204343_().anyMatch(SOUL_TORCH_MATCH)) {
                    DangerClose.immolateSoul(entity);
                } else if (stateBelow.m_204343_().anyMatch(SOUL_TORCH_MATCH)) {
                    DangerClose.immolateSoul(entity);
                }
            }
            if (CommonConfigValues.shouldCampfireImmolate && !hasFrostWalker) {
                if (stateInside.m_204343_().anyMatch(CAMPFIRE_MATCH) && ((Boolean)stateInside.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    DangerClose.immolate(entity);
                } else if (stateBelow.m_204343_().anyMatch(CAMPFIRE_MATCH) && ((Boolean)stateBelow.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    DangerClose.immolate(entity);
                }
            }
            if (CommonConfigValues.shouldSoulCampfireImmolate && !hasFrostWalker) {
                if (stateInside.m_204343_().anyMatch(SOUL_CAMPFIRE_MATCH) && ((Boolean)stateInside.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    DangerClose.immolateSoul(entity);
                } else if (stateBelow.m_204343_().anyMatch(SOUL_CAMPFIRE_MATCH) && ((Boolean)stateBelow.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    DangerClose.immolateSoul(entity);
                }
            }
            if (CommonConfigValues.shouldMagmaBlockImmolate && !hasFrostWalker && !entity.m_6144_()) {
                if (stateInside.m_204343_().anyMatch(MAGMA_MATCH)) {
                    DangerClose.immolate(entity);
                } else if (stateBelow.m_204343_().anyMatch(MAGMA_MATCH)) {
                    DangerClose.immolate(entity);
                }
            }
            if (CommonConfigValues.shouldStonecutterCut && !entity.m_6144_()) {
                if (stateInside.m_204343_().anyMatch(STONECUTTER_MATCH)) {
                    entity.m_6469_(level.m_269111_().m_269264_(), 4.0f);
                } else if (stateBelow.m_204343_().anyMatch(STONECUTTER_MATCH)) {
                    entity.m_6469_(level.m_269111_().m_269264_(), 4.0f);
                }
            }
        }
        List nearby = level.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, entity, entity.m_20191_());
        for (LivingEntity living : nearby) {
            DangerClose.spreadFire(entity, living);
        }
    }

    public static void immolate(LivingEntity entity) {
        entity.m_7311_(40);
    }

    public static void immolateSoul(LivingEntity entity) {
        if (!isSoulFiredLoaded) {
            DangerClose.immolate(entity);
        } else {
            SoulFired.immolateSoul(entity);
        }
    }

    public static void spreadFire(LivingEntity entityA, LivingEntity entityB) {
        if (entityA.m_6060_() && !entityB.m_6060_()) {
            if (isSoulFiredLoaded) {
                SoulFired.spreadTypedFire(entityA, entityB);
                return;
            }
            DangerClose.immolate(entityB);
        } else if (!entityA.m_6060_() && entityB.m_6060_()) {
            if (isSoulFiredLoaded) {
                SoulFired.spreadTypedFire(entityA, entityB);
                return;
            }
            DangerClose.immolate(entityA);
        }
        if (CommonConfigValues.shouldBlazeImmolate && entityB instanceof Blaze) {
            DangerClose.immolate(entityA);
        }
        if (CommonConfigValues.shouldMagmaCubeImmolate && !entityA.m_6060_() && (entityB instanceof MagmaCube || entityB.m_6095_() == EntityType.f_20468_)) {
            DangerClose.immolate(entityA);
        }
    }
}

