/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxencedc.sparsestructures;

import com.google.gson.Gson;
import io.github.maxencedc.sparsestructures.Constants;
import io.github.maxencedc.sparsestructures.SparseStructuresConfig;
import io.github.maxencedc.sparsestructures.platform.Services;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class SparseStructuresCommon {
    public static SparseStructuresConfig config;

    public static void init() {
        if (Services.PLATFORM.isModLoaded("sparsestructures")) {
            InputStream in;
            if (!Constants.CONFIG_FILE_PATH.toFile().exists()) {
                try {
                    in = SparseStructuresCommon.class.getClassLoader().getResourceAsStream("sparse-structures-default-config.json5");
                    try {
                        if (in == null) {
                            throw new IllegalStateException("Failed to load SparseStructure's default config \"sparse-structures-default-config.json5\"");
                        }
                        Files.createDirectories(Constants.CONFIG_FILE_PATH, new FileAttribute[0]);
                        Files.copy(in, Constants.CONFIG_FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                in = Files.newInputStream(Constants.CONFIG_FILE_PATH, new OpenOption[0]);
                try {
                    config = (SparseStructuresConfig)new Gson().fromJson((Reader)new InputStreamReader(in), SparseStructuresConfig.class);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("SparseStructure's config file is malformed! If you don't know what's causing this, delete the config file and restart the game.");
            }
        }
    }
}

