/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.Map;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.network.CMessageEffectFinished;
import ovh.corail.tombstone.network.CMessageEffectStarted;
import ovh.corail.tombstone.network.PacketHandler;

public class TombstoneEffect
extends MobEffect {
    private boolean noAttributeScale = false;
    private boolean isInstantenous = false;
    private boolean requireSync = false;

    public TombstoneEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        if (this.requireSync && !livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_()) {
            @Nullable MobEffectInstance effectInstance = livingEntity.m_21221_().entrySet().stream().filter(entry -> ((MobEffectInstance)entry.getValue()).m_19544_() == this).findFirst().map(Map.Entry::getValue).orElse(null);
            Optional.ofNullable(effectInstance).ifPresent(e -> PacketHandler.sendToAllTrackingPlayers(new CMessageEffectStarted(livingEntity.m_19879_(), effectInstance), livingEntity));
        }
    }

    public void onEffectFinished(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        if (this.requireSync && !livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_()) {
            PacketHandler.sendToAllTrackingPlayers(new CMessageEffectFinished(livingEntity.m_19879_(), effectInstance.m_19544_()), livingEntity);
        }
    }

    public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(livingEntity, attributeMap, this.noAttributeScale ? 0 : amplifier);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
    }

    public void m_19461_(@Nullable Entity directEntity, @Nullable Entity causingEntity, LivingEntity livingEntity, int amplifier, double value) {
        this.m_6742_(livingEntity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public boolean m_8093_() {
        return this.isInstantenous;
    }

    public TombstoneEffect setInstantenous() {
        this.isInstantenous = true;
        return this;
    }

    public TombstoneEffect noAttributeScale() {
        this.noAttributeScale = true;
        return this;
    }

    public boolean isRequiringSync() {
        return this.requireSync;
    }

    public TombstoneEffect requireSync() {
        this.requireSync = true;
        return this;
    }
}

