/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class FrostbiteEffect
extends TombstoneEffect {
    private static final UUID SPEED_MODIFIER_POWDER_SNOW_ID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final String FROSTBITE_APPLIER = "frostbite_applier";

    public FrostbiteEffect() {
        super(MobEffectCategory.HARMFUL, -6231318);
    }

    @Override
    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_()) {
            LivingEntity livingEntity2;
            CompoundTag tag = livingEntity.getPersistentData();
            if (livingEntity.m_21213_() == livingEntity.f_19797_ && (livingEntity2 = livingEntity.m_21188_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                tag.m_128362_(FROSTBITE_APPLIER, serverPlayer.m_20148_());
            } else {
                tag.m_128473_(FROSTBITE_APPLIER);
            }
        }
    }

    @Override
    public void onEffectFinished(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        CompoundTag tag;
        super.onEffectFinished(livingEntity, effectInstance);
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_() && (tag = livingEntity.getPersistentData()).m_128441_(FROSTBITE_APPLIER)) {
            tag.m_128473_(FROSTBITE_APPLIER);
        }
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_()) {
            livingEntity.m_146917_(Math.min(livingEntity.m_146891_(), livingEntity.m_146888_() + 3));
            Optional.ofNullable(livingEntity.m_21051_(Attributes.f_22279_)).ifPresent(movementSpeedAttribute -> {
                movementSpeedAttribute.m_22120_(SPEED_MODIFIER_POWDER_SNOW_ID);
                movementSpeedAttribute.m_22118_(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, "Powder snow slow", (double)(-0.05f * livingEntity.m_146889_()), AttributeModifier.Operation.ADDITION));
            });
            if (livingEntity.m_146890_() && TimeHelper.atInterval(livingEntity.m_9236_(), 20)) {
                ServerPlayer player;
                MinecraftServer server;
                LivingEntity attacker = livingEntity;
                CompoundTag tag = livingEntity.getPersistentData();
                if (tag.m_128441_(FROSTBITE_APPLIER) && (server = livingEntity.m_20194_()) != null && (player = server.m_6846_().m_11259_(tag.m_128342_(FROSTBITE_APPLIER))) != null) {
                    attacker = player;
                }
                Helper.hurtWithoutCooldown(livingEntity, livingEntity.m_269291_().m_269298_(DamageTypes.f_268444_, (Entity)attacker), amplifier + 1);
            }
        }
    }
}

