/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client;

import com.yungnickyoung.minecraft.ribbits.client.RibbitsCommonClient;
import com.yungnickyoung.minecraft.ribbits.client.model.SupporterHatModel;
import com.yungnickyoung.minecraft.ribbits.client.particle.RibbitSpellParticle;
import com.yungnickyoung.minecraft.ribbits.client.render.RibbitRenderer;
import com.yungnickyoung.minecraft.ribbits.module.BlockModule;
import com.yungnickyoung.minecraft.ribbits.module.EntityTypeModule;
import com.yungnickyoung.minecraft.ribbits.module.ParticleTypeModule;
import com.yungnickyoung.minecraft.ribbits.network.ClientPacketHandlerForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class RibbitsForgeClient {
    public static void init() {
        RibbitsCommonClient.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RibbitsForgeClient::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RibbitsForgeClient::registerRenderers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RibbitsForgeClient::registerLayers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RibbitsForgeClient::registerParticleFactories);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.SWAMP_LANTERN.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.GIANT_LILYPAD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.SWAMP_DAISY.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.TOADSTOOL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.UMBRELLA_LEAF.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.MOSSY_OAK_DOOR.get()), (RenderType)RenderType.m_110463_());
        MinecraftForge.EVENT_BUS.addListener(ClientPacketHandlerForge::onEntityJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(ClientPacketHandlerForge::onLevelUnload);
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityTypeModule.RIBBIT.get(), RibbitRenderer::new);
    }

    private static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SupporterHatModel.LAYER_LOCATION, SupporterHatModel::getTexturedModelData);
    }

    private static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleTypeModule.SPELL.get(), RibbitSpellParticle.Factory::new);
    }
}

