/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.new_shield_variants.core.world.item;

import forge.com.cursee.new_shield_variants.core.registry.ModItems;
import forge.com.cursee.new_shield_variants.core.world.item.NSVShieldItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class NSVTickInteractions {
    public static void handle(ServerPlayer player) {
        Item item = player.m_21211_().m_41720_();
        if (!(item instanceof NSVShieldItem)) {
            return;
        }
        NSVShieldItem shield = (NSVShieldItem)item;
        switch (shield.variant) {
            case ENDER: {
                NSVTickInteractions.enderShield(player.m_9236_(), (Player)player);
                break;
            }
            case SHULKER: {
                NSVTickInteractions.shulkerShield((Player)player);
            }
        }
    }

    private static void shulkerShield(Player player) {
        if (player.m_21205_().m_150930_(ModItems.SHULKER_SHIELD) || player.m_21206_().m_150930_(ModItems.SHULKER_SHIELD)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, (int)(player.m_217043_().m_188500_() * 40.0)));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, (int)(player.m_217043_().m_188500_() * 160.0)));
        }
    }

    private static void enderShield(Level level, Player player) {
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.m_21205_().m_150930_(ModItems.ENDER_SHIELD) || player.m_21206_().m_150930_(ModItems.ENDER_SHIELD)) {
            LivingEntity targetForTeleportation;
            LivingEntity lastAttacker = player.m_21188_();
            List nearbyLivingEntities = serverLevel.m_45971_(LivingEntity.class, TargetingConditions.m_148353_(), (LivingEntity)player, player.m_20191_().m_82400_(3.0));
            LivingEntity livingEntity = targetForTeleportation = lastAttacker == null && !nearbyLivingEntities.isEmpty() ? (LivingEntity)nearbyLivingEntities.get(0) : lastAttacker;
            if (targetForTeleportation != null && NSVTickInteractions.randomTeleport(targetForTeleportation)) {
                player.m_5810_();
                player.m_6703_(null);
                player.m_36335_().m_41524_(player.m_21120_(player.m_7655_()).m_41720_(), 100);
            }
        }
    }

    public static boolean randomTeleport(LivingEntity livingEntity) {
        Level level = livingEntity.m_9236_();
        double randomXPosRange = livingEntity.m_20185_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
        double randomYPosRange = Mth.m_14008_((double)(livingEntity.m_20186_() + (double)(livingEntity.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_141937_() + ((ServerLevel)level).m_143344_() - 1));
        double randomZPosRange = livingEntity.m_20189_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
        if (livingEntity.m_20159_()) {
            livingEntity.m_8127_();
        }
        Vec3 entityPos = livingEntity.m_20182_();
        if (livingEntity.m_20984_(randomXPosRange, randomYPosRange, randomZPosRange, true)) {
            level.m_214171_(GameEvent.f_238175_, entityPos, GameEvent.Context.m_223717_((Entity)livingEntity));
            level.m_247517_((Player)null, BlockPos.m_274561_((double)livingEntity.m_20185_(), (double)livingEntity.m_20186_(), (double)livingEntity.m_20189_()), SoundEvents.f_11757_, SoundSource.NEUTRAL);
            livingEntity.m_183634_();
            return true;
        }
        level.m_214171_(GameEvent.f_238175_, entityPos, GameEvent.Context.m_223717_((Entity)livingEntity));
        level.m_247517_((Player)null, BlockPos.m_274561_((double)livingEntity.m_20185_(), (double)livingEntity.m_20186_(), (double)livingEntity.m_20189_()), SoundEvents.f_11757_, SoundSource.NEUTRAL);
        livingEntity.m_183634_();
        return false;
    }
}

