/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.world.block;

import forge.com.cursee.disenchanting_table.client.ClientConfig;
import forge.com.cursee.disenchanting_table.core.registry.ModBlockEntities;
import forge.com.cursee.disenchanting_table.core.world.block.entity.DisenchantingTableBlockEntity;
import forge.com.cursee.disenchanting_table.core.world.block.entity.util.SimpleInventoryBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisenchantingTableBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE;
    public static final DirectionProperty FACING;

    public DisenchantingTableBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50201_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            player.m_5893_(menuProvider);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new DisenchantingTableBlockEntity(blockPos, blockState);
    }

    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? DisenchantingTableBlock.createTickerHelper(blockEntityType, ModBlockEntities.DISENCHANTING_TABLE, DisenchantingTableBlockEntity::tickClient) : DisenchantingTableBlock.createTickerHelper(blockEntityType, ModBlockEntities.DISENCHANTING_TABLE, DisenchantingTableBlockEntity::tickServer);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity block = world.m_7702_(pos);
        if (block instanceof DisenchantingTableBlockEntity) {
            DisenchantingTableBlockEntity table = (DisenchantingTableBlockEntity)block;
            return table.getSignal();
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.m_60713_(state.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!ClientConfig.render_block_particles) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int xMod = random.m_188503_(2) * 2 - 1;
            int zMod = random.m_188503_(2) * 2 - 1;
            double xPos = (double)pos.m_123341_() + 0.5 + 0.25 * (double)xMod;
            double yPos = (float)pos.m_123342_() + random.m_188501_();
            double zPos = (double)pos.m_123343_() + 0.5 + 0.25 * (double)zMod;
            double xSpeed = random.m_188501_() * (float)xMod;
            double ySpeed = ((double)random.m_188501_() - 0.5) * 0.125;
            double zSpeed = random.m_188501_() * (float)zMod;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    static {
        FACING = BlockStateProperties.f_61374_;
        SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    }
}

