/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.network.packet;

import forge.com.cursee.disenchanting_table.client.network.packet.ForgeItemSyncClientHandler;
import forge.com.cursee.disenchanting_table.core.network.ForgeNetwork;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ForgeItemSyncS2CPacket {
    private final NonNullList<ItemStack> items;
    private final BlockPos pos;

    public ForgeItemSyncS2CPacket(NonNullList<ItemStack> items, BlockPos pos) {
        this.items = items;
        this.pos = pos;
    }

    public void encode(FriendlyByteBuf data) {
        data.writeInt(this.items.size());
        this.items.forEach(arg_0 -> ((FriendlyByteBuf)data).m_130055_(arg_0));
        data.m_130064_(this.pos);
    }

    public static ForgeItemSyncS2CPacket decode(FriendlyByteBuf data) {
        int size = data.readInt();
        NonNullList items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            items.set(i, (Object)data.m_130267_());
        }
        BlockPos position = data.m_130135_();
        return new ForgeItemSyncS2CPacket((NonNullList<ItemStack>)items, position);
    }

    public static void handle(ForgeItemSyncS2CPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ForgeItemSyncS2CPacket.lambda$handle$1(packet, (Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static void createAndSend(ServerPlayer serverPlayer, NonNullList<ItemStack> inventory, BlockPos blockPos) {
        ForgeNetwork.sendToPlayer(new ForgeItemSyncS2CPacket(inventory, blockPos), serverPlayer);
    }

    private static /* synthetic */ Runnable lambda$handle$1(ForgeItemSyncS2CPacket packet, Supplier contextSupplier) {
        return () -> ForgeItemSyncS2CPacket.lambda$handle$0(packet, (Supplier)contextSupplier);
    }

    private static /* synthetic */ void lambda$handle$0(ForgeItemSyncS2CPacket packet, Supplier contextSupplier) {
        ForgeItemSyncClientHandler.handleOnClient(packet, contextSupplier);
    }
}

