/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table.core.world.inventory;

import fabric.com.cursee.disenchanting_table.core.ServerConfig;
import fabric.com.cursee.disenchanting_table.core.registry.ModBlocks;
import fabric.com.cursee.disenchanting_table.core.registry.ModMenus;
import fabric.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import fabric.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_4861;
import net.minecraft.class_8047;

public class DisenchantingMenu
extends class_4861 {
    public int cost = 0;
    public final class_3915 mayPickup = class_3915.method_17403();
    private final class_1657 playerReference;
    @Nullable
    private class_1887 keptEnchantment;
    @Nullable
    private Integer keptEnchantmentLevel;
    @Nullable
    private Map<class_1887, Integer> stolenEnchantments;

    public DisenchantingMenu(int containerIndex, class_1661 inventory) {
        this(containerIndex, inventory, class_3914.field_17304);
    }

    public DisenchantingMenu(int containerIndex, class_1661 inventory, class_3914 access) {
        super(ModMenus.DISENCHANTING_MENU, containerIndex, inventory, access);
        this.method_17362(this.mayPickup);
        this.mayPickup.method_17404(this.cost);
        this.playerReference = inventory.field_7546;
    }

    protected boolean method_24925(class_2680 blockState) {
        return blockState.method_27852(ModBlocks.DISENCHANTING_TABLE);
    }

    protected class_8047 method_48352() {
        return class_8047.method_48364().method_48374(0, 27, 47, DisenchantmentHelper::canDisenchant).method_48374(1, 76, 47, stack -> stack.method_31574(class_1802.field_8529)).method_48373(2, 134, 47).method_48372();
    }

    public boolean hasResult() {
        return !this.field_22479.method_5442();
    }

    private void reset() {
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = null;
        this.stolenEnchantments = null;
        this.field_22479.method_5447(0, class_1799.field_8037);
        this.cost = 0;
        this.mayPickup.method_17404(0);
    }

    private void disenchantNormal(class_1799 input) {
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = null;
        this.stolenEnchantments = class_1890.method_8222((class_1799)input);
        class_1799 result = new class_1799((class_1935)class_1802.field_8598);
        class_1890.method_8214(this.stolenEnchantments, (class_1799)result);
        this.field_22479.method_5447(0, result);
    }

    private void disenchantBookWithMany(class_1799 input) {
        this.stolenEnchantments = class_1890.method_8222((class_1799)input);
        this.keptEnchantment = this.stolenEnchantments.keySet().iterator().next();
        this.keptEnchantmentLevel = this.stolenEnchantments.get(this.keptEnchantment);
        this.stolenEnchantments.remove(this.keptEnchantment);
        class_1799 result = new class_1799((class_1935)class_1802.field_8598);
        class_1890.method_8214(this.stolenEnchantments, (class_1799)result);
        this.field_22479.method_5447(0, result);
    }

    boolean satisfiesCost() {
        class_1657 class_16572 = this.playerReference;
        if (!(class_16572 instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        int currentExperience = ExperienceHelper.getTotalPlayerExperiencePoints((class_1657)serverPlayer);
        boolean creative = this.field_22482.method_31549().field_7477;
        boolean experiencePoints = ServerConfig.uses_points && currentExperience >= this.cost;
        boolean experienceLevels = !ServerConfig.uses_points && serverPlayer.field_7520 >= this.cost;
        boolean experience = experiencePoints || experienceLevels;
        boolean books = this.field_22480.method_5438(1).method_31574(class_1802.field_8529);
        return (creative || experience) && books;
    }

    public void method_24928() {
        class_1657 class_16572 = this.playerReference;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        class_1799 input = this.field_22480.method_5438(0);
        class_1799 book = this.field_22480.method_5438(1);
        if (!DisenchantmentHelper.canDisenchant(input) || !book.method_31574(class_1802.field_8529)) {
            this.reset();
            return;
        }
        if (!input.method_31574(class_1802.field_8598)) {
            this.disenchantNormal(input);
        } else if (class_1890.method_8222((class_1799)input).size() > 1) {
            this.disenchantBookWithMany(input);
        } else if (class_1890.method_8222((class_1799)input).size() == 1) {
            class_1799 result = input.method_7972();
            if (ServerConfig.resets_repair_cost) {
                result.method_7927(0);
            }
            this.field_22479.method_5447(0, result);
        }
        if (!ServerConfig.requires_experience && !this.hasResult()) {
            return;
        }
        boolean requiresExperience = ServerConfig.requires_experience;
        boolean satisfiesCost = this.satisfiesCost();
        this.mayPickup.method_17404(requiresExperience && satisfiesCost ? 1 : 0);
        this.cost = ServerConfig.experience_cost;
    }

    protected boolean method_24927(@Nonnull class_1657 player, boolean b) {
        this.mayPickup.method_17404(this.satisfiesCost() ? 1 : 0);
        return this.mayPickup.method_17407() == 1;
    }

    protected void method_24923(class_1657 player, class_1799 itemStack) {
        this.field_22481.method_17393((level, blockPos) -> level.method_20290(1503, blockPos, 0));
        if (!(player instanceof class_3222)) {
            return;
        }
        class_1799 input = this.field_22480.method_5438(0);
        class_1799 extra = this.field_22480.method_5438(1);
        if (!input.method_31574(class_1802.field_8598)) {
            if (ServerConfig.resets_repair_cost) {
                input.method_7927(0);
            }
            class_1890.method_8214((Map)class_1890.method_8222((class_1799)class_1799.field_8037), (class_1799)input);
            this.field_22480.method_5447(0, input);
        } else if (input.method_31574(class_1802.field_8598) && class_1890.method_8222((class_1799)input).size() > 1) {
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            this.field_22480.method_5447(0, class_1772.method_7808((class_1889)new class_1889(this.keptEnchantment, this.keptEnchantmentLevel.intValue())));
        } else if (input.method_31574(class_1802.field_8598) && class_1890.method_8222((class_1799)input).size() == 1) {
            this.field_22480.method_5447(0, class_1799.field_8037);
        }
        extra.method_7934(1);
        this.field_22480.method_5447(1, extra);
        if (!ServerConfig.requires_experience) {
            return;
        }
        if (ServerConfig.uses_points) {
            player.method_7255(-ServerConfig.experience_cost);
        } else {
            player.method_7316(-ServerConfig.experience_cost);
        }
        this.reset();
        if (!input.method_7960() && input.method_7928() > 0) {
            this.method_24928();
        }
    }
}

