/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.core.world.block.entity;

import common.com.cursee.disenchanting_table.core.ServerConfig;
import common.com.cursee.disenchanting_table.core.registry.ModBlockEntities;
import common.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import common.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import common.com.cursee.disenchanting_table.core.util.S2CBlockEntityUpdatePacket;
import common.com.cursee.disenchanting_table.core.world.block.entity.util.ExposedSimpleInventoryBlockEntity;
import common.com.cursee.disenchanting_table.core.world.block.entity.util.SimpleInventoryBlockEntity;
import common.com.cursee.disenchanting_table.core.world.inventory.DisenchantingMenu;
import common.com.cursee.disenchanting_table.core.world.inventory.DisenchantingTableMenu;
import common.com.cursee.disenchanting_table.platform.Services;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DisenchantingTableBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements MenuProvider {
    public static final int INPUT_SLOT = 0;
    public static final int EXTRA_SLOT = 1;
    public static final int OUTER_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    private int signal = 0;
    private boolean dirty = false;
    private static final int MAX_PROGRESS = 10;
    private int progress = 0;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int i) {
            if (i == 0) {
                return DisenchantingTableBlockEntity.this.progress;
            }
            return 0;
        }

        public void m_8050_(int i, int v) {
            if (i == 0) {
                DisenchantingTableBlockEntity.this.progress = v;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    @Nullable
    private Enchantment keptEnchantment = null;
    @Nullable
    private Integer keptEnchantmentLevel = null;
    @Nullable
    private Map<Enchantment, Integer> stolenEnchantments = null;

    public DisenchantingTableBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DISENCHANTING_TABLE, pos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"itemGroup.disenchantingTable");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (this.f_58857_ == null) {
            return null;
        }
        return ServerConfig.automatic_disenchanting ? new DisenchantingTableMenu(i, inventory, (Container)this, this.dataAccess) : new DisenchantingMenu(i, inventory, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (!ServerConfig.automatic_disenchanting) {
            return false;
        }
        if (index == 0 && !DisenchantmentHelper.canDisenchant(stack)) {
            return true;
        }
        return index == 2;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(3){

            public boolean m_7013_(int index, ItemStack stack) {
                if (!ServerConfig.automatic_disenchanting) {
                    return false;
                }
                return index == 0 && DisenchantmentHelper.canDisenchant(stack) || index == 1 && stack.m_150930_(Items.f_42517_);
            }
        };
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, DisenchantingTableBlockEntity table) {
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, DisenchantingTableBlockEntity table) {
        boolean validInputs;
        if (!ServerConfig.automatic_disenchanting) {
            return;
        }
        Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 16.0, false);
        if (player == null || !DisenchantingTableBlockEntity.hasEnoughExperience(player)) {
            return;
        }
        boolean bl = validInputs = DisenchantmentHelper.canDisenchant(table.m_8020_(0)) && table.m_8020_(1).m_150930_(Items.f_42517_);
        if (validInputs && table.m_8020_(2).m_41619_()) {
            if (table.progress >= 10) {
                table.disenchant(level, pos, player);
                level.m_46796_(1503, pos, 0);
                table.progress = 0;
            }
            ++table.progress;
            table.dirty = true;
        } else {
            table.progress = 0;
        }
        int newSignal = 0;
        Container container = table.getItemHandler();
        if (!container.m_7983_()) {
            if (!container.m_8020_(0).m_41619_()) {
                newSignal = 3;
                if (!container.m_8020_(1).m_41619_()) {
                    newSignal = 6;
                }
            }
            if (!container.m_8020_(2).m_41619_()) {
                newSignal = 9;
            }
        }
        if (newSignal != table.signal) {
            table.signal = newSignal;
            level.m_46717_(pos, state.m_60734_());
        }
        if (table.dirty) {
            table.dirty = false;
            S2CBlockEntityUpdatePacket.sendToClients(table);
        }
    }

    private static boolean hasEnoughExperience(Player player) {
        if (!ServerConfig.requires_experience) {
            return true;
        }
        if (ServerConfig.uses_points && ExperienceHelper.hasEnoughExperiencePoints(player, ServerConfig.experience_cost)) {
            return true;
        }
        if (!ServerConfig.uses_points && ExperienceHelper.hasEnoughExperienceLevels(player, ServerConfig.experience_cost)) {
            return true;
        }
        return player.m_7500_();
    }

    private void disenchant(Level level, BlockPos pos, Player player) {
        ItemStack input = this.m_8020_(0);
        if (!input.m_150930_(Items.f_42690_)) {
            this.stolenEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
            ItemStack result = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_(this.stolenEnchantments, (ItemStack)result);
            if (ServerConfig.resets_repair_cost) {
                result.m_41742_(0);
            }
            this.m_6836_(2, result);
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)ItemStack.f_41583_), (ItemStack)input);
            if (ServerConfig.resets_repair_cost) {
                input.m_41742_(0);
            }
            this.m_6836_(0, input);
            this.removeNormalBook();
        } else {
            this.stolenEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
            this.keptEnchantment = this.stolenEnchantments.keySet().iterator().next();
            this.keptEnchantmentLevel = this.stolenEnchantments.get(this.keptEnchantment);
            this.stolenEnchantments.remove(this.keptEnchantment);
            ItemStack result = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_(this.stolenEnchantments, (ItemStack)result);
            if (ServerConfig.resets_repair_cost) {
                result.m_41742_(0);
            }
            this.m_6836_(2, result);
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            ItemStack keptEnchantedBook = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(this.keptEnchantment, this.keptEnchantmentLevel.intValue()));
            if (ServerConfig.resets_repair_cost) {
                keptEnchantedBook.m_41742_(0);
            }
            this.m_6836_(0, keptEnchantedBook);
            this.removeNormalBook();
        }
        if (!player.m_7500_()) {
            if (ServerConfig.uses_points) {
                ExperienceHelper.deductExperiencePoints(player, ServerConfig.experience_cost);
            } else {
                ExperienceHelper.deductExperienceLevels(player, ServerConfig.experience_cost);
            }
        }
    }

    public void removeNormalBook() {
        ItemStack bookStack = this.m_8020_(1);
        bookStack.m_41774_(1);
        this.m_6836_(1, bookStack);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("Progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.dirty = true;
            for (Player player : this.f_58857_.m_6907_()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Services.PLATFORM.sendItemSyncToClient(serverPlayer, SimpleInventoryBlockEntity.copyFromInv((Container)this), this.m_58899_());
            }
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public int getSignal() {
        return this.signal;
    }

    public ItemStack getRenderStack() {
        return !this.m_8020_(2).m_41619_() ? this.m_8020_(2) : this.m_8020_(0);
    }
}

