/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import common.com.cursee.disenchanting_table.client.ClientConfig;
import common.com.cursee.disenchanting_table.core.ServerConfig;
import common.com.cursee.disenchanting_table.core.world.block.DisenchantingTableBlock;
import common.com.cursee.disenchanting_table.core.world.block.entity.DisenchantingTableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class DisenchantingTableRenderer
implements BlockEntityRenderer<DisenchantingTableBlockEntity> {
    private static final ItemStack MANUAL_STACK = new ItemStack((ItemLike)Items.f_42690_);

    public DisenchantingTableRenderer(BlockEntityRendererProvider.Context context) {
    }

    private static int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.m_45517_(LightLayer.BLOCK, pos);
        int sLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }

    public void render(DisenchantingTableBlockEntity table, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (!ClientConfig.render_table_item) {
            return;
        }
        if (table.m_58904_() == null) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack itemStack = table.getRenderStack();
        if (!ServerConfig.automatic_disenchanting) {
            itemStack = MANUAL_STACK;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.75f, 0.5f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        Direction facing = (Direction)table.m_58900_().m_61143_((Property)DisenchantingTableBlock.FACING);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(facing != Direction.EAST && facing != Direction.WEST ? facing.m_122424_().m_122435_() : facing.m_122435_()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, DisenchantingTableRenderer.getLightLevel(table.m_58904_(), table.m_58899_()), OverlayTexture.f_118083_, poseStack, multiBufferSource, table.m_58904_(), 1);
        poseStack.m_85849_();
    }
}

