/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.PingController;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.render.WorldRenderContext;

public class PingManager {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    public static final ArrayList<PingView> PING_REPO = new ArrayList();

    private PingManager() {
    }

    public static void clearPings() {
        PING_REPO.clear();
    }

    public static void addOrReplacePing(PingView newPing) {
        int index = -1;
        for (int i = 0; i < PING_REPO.size(); ++i) {
            PingView entry = PING_REPO.get(i);
            if (!Objects.equals(entry.authorId, newPing.authorId) || entry.sequence != newPing.sequence) continue;
            index = i;
            break;
        }
        if (index != -1) {
            PING_REPO.set(index, newPing);
        } else {
            PING_REPO.add(newPing);
        }
    }

    public static void updatePings(WorldRenderContext ctx) {
        if (CommonClient.Game.f_91073_ == null || PING_REPO.isEmpty()) {
            return;
        }
        int time = (int)CommonClient.Game.f_91073_.m_46467_();
        PingView target = null;
        Iterator<PingView> iter = PING_REPO.iterator();
        while (iter.hasNext()) {
            PingView ping = iter.next();
            ping.update(ctx, time);
            if (ping.isExpired()) {
                iter.remove();
                continue;
            }
            if (!PingController.isPingQueued() || !ping.isRemovable() || !ping.isCloserToCenter(target)) continue;
            target = ping;
        }
        if (target != null && PING_REPO.remove(target)) {
            PingController.revokePingAction();
        }
        PING_REPO.sort((a, b) -> Double.compare(b.getDistance(), a.getDistance()));
    }

    public static void acceptPingPacket(PingLocationS2CPacket packet) {
        Vec3 vecToPing;
        if (packet.isCorrupt()) {
            Global.LOGGER.warn("received invalid ping location from server");
            return;
        }
        ClientPacketListener connection = CommonClient.Game.m_91403_();
        if (CommonClient.Game.f_91074_ == null || CommonClient.Game.f_91073_ == null || connection == null) {
            return;
        }
        if (!packet.channel().equals(CLIENT_CONFIG.getChannel())) {
            return;
        }
        if (CLIENT_CONFIG.getPingDistance() < 2048 && (vecToPing = CommonClient.Game.f_91074_.m_20182_().m_82505_(packet.pos())).m_82553_() > (double)CLIENT_CONFIG.getPingDistance()) {
            return;
        }
        CommonClient.Game.execute(() -> {
            PingView newPing = PingView.from(packet);
            PingManager.addOrReplacePing(newPing);
            newPing.playSoundInDimension();
        });
    }
}

