/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.golden_foods.core.registry;

import forge.com.cursee.golden_foods.core.registry.ModBlocksForge;
import forge.com.cursee.golden_foods.core.registry.ModEnchantmentsForge;
import forge.com.cursee.golden_foods.core.registry.ModItemsForge;
import forge.com.cursee.golden_foods.core.registry.ModTabsForge;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryForge {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"golden_foods");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"golden_foods");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)BuiltInRegistries.f_279662_.m_123023_(), (String)"golden_foods");
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"golden_foods");

    public static void register(IEventBus modEventBus) {
        ModBlocksForge.register();
        ModItemsForge.register();
        ModTabsForge.register();
        ModEnchantmentsForge.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
        ENCHANTMENTS.register(modEventBus);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String blockID, Supplier<T> blockSupplier) {
        return BLOCKS.register(blockID, blockSupplier);
    }

    public static <T extends Item> RegistryObject<T> registerItem(String itemID, Supplier<T> itemSupplier) {
        return ITEMS.register(itemID, itemSupplier);
    }

    public static <T extends Block> RegistryObject<T> registerBlockWithItem(String blockID, Supplier<T> blockSupplier) {
        RegistryObject toReturn = RegistryForge.registerBlock(blockID, blockSupplier);
        RegistryForge.registerItem(blockID, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends CreativeModeTab> RegistryObject<T> registerTab(String tabID, Supplier<T> tabSupplier) {
        return TABS.register(tabID, tabSupplier);
    }

    public static <T extends Enchantment> RegistryObject<T> registerEnchantment(String enchantmentID, Supplier<T> enchantmentSupplier) {
        return ENCHANTMENTS.register(enchantmentID, enchantmentSupplier);
    }
}

