/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.platform;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.com.cursee.overclocked_watches.OverclockedWatchesUtil;
import forge.com.cursee.overclocked_watches.client.item.renderer.IWatchRenderer;
import forge.com.cursee.overclocked_watches.core.registry.ModItemsForge;
import forge.com.cursee.overclocked_watches.core.registry.ModParticlesForge;
import forge.com.cursee.overclocked_watches.platform.services.IPlatformHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getGameDirectory() {
        return FMLPaths.GAMEDIR.get().toString();
    }

    public IWatchRenderer getWatchRenderer(Item item) {
        Object t;
        Optional renderer = CuriosRendererRegistry.getRenderer((Item)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof WatchCurioRenderer) {
            WatchCurioRenderer artifactTrinketRenderer = (WatchCurioRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    @Override
    public <T extends Item> void registerWatchRenderer(T item, Supplier<IWatchRenderer> rendererSupplier) {
        CuriosRendererRegistry.register(item, () -> new WatchCurioRenderer((IWatchRenderer)rendererSupplier.get()));
    }

    @Override
    public Supplier<Item> getRegisteredGoldenWatchItem() {
        return () -> (Item)ModItemsForge.GOLDEN_WATCH.get();
    }

    @Override
    public Supplier<Item> getRegisteredDiamondWatchItem() {
        return () -> (Item)ModItemsForge.DIAMOND_WATCH.get();
    }

    @Override
    public Supplier<Item> getRegisteredNetheriteWatchItem() {
        return () -> (Item)ModItemsForge.NETHERITE_WATCH.get();
    }

    @Override
    public boolean playerHasGoldenWatchEquipped(Player player) {
        AtomicBoolean foundWatch = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            if (iCuriosItemHandler.isEquipped((Item)ModItemsForge.GOLDEN_WATCH.get())) {
                foundWatch.set(true);
            }
        });
        return foundWatch.get();
    }

    @Override
    public boolean playerHasDiamondWatchEquipped(Player player) {
        AtomicBoolean foundWatch = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            if (iCuriosItemHandler.isEquipped((Item)ModItemsForge.DIAMOND_WATCH.get())) {
                foundWatch.set(true);
            }
        });
        return foundWatch.get();
    }

    @Override
    public boolean playerHasNetheriteWatchEquipped(Player player) {
        AtomicBoolean foundWatch = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            if (iCuriosItemHandler.isEquipped((Item)ModItemsForge.NETHERITE_WATCH.get())) {
                foundWatch.set(true);
            }
        });
        return foundWatch.get();
    }

    @Override
    public ItemStack getEquippedGoldenWatch(Player player) {
        AtomicReference<ItemStack> itemStackReference = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio((Item)ModItemsForge.GOLDEN_WATCH.get()).ifPresent(slotResult -> itemStackReference.set(slotResult.stack())));
        return itemStackReference.get();
    }

    @Override
    public ItemStack getEquippedDiamondWatch(Player player) {
        AtomicReference<ItemStack> itemStackReference = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio((Item)ModItemsForge.DIAMOND_WATCH.get()).ifPresent(slotResult -> itemStackReference.set(slotResult.stack())));
        return itemStackReference.get();
    }

    @Override
    public ItemStack getEquippedNetheriteWatch(Player player) {
        AtomicReference<ItemStack> itemStackReference = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio((Item)ModItemsForge.NETHERITE_WATCH.get()).ifPresent(slotResult -> itemStackReference.set(slotResult.stack())));
        return itemStackReference.get();
    }

    @Override
    public SimpleParticleType getGoldenWatchGrowthParticle() {
        return (SimpleParticleType)ModParticlesForge.GOLDEN_WATCH_GROWTH.get();
    }

    @Override
    public SimpleParticleType getDiamondWatchGrowthParticle() {
        return (SimpleParticleType)ModParticlesForge.DIAMOND_WATCH_GROWTH.get();
    }

    @Override
    public SimpleParticleType getNetheriteWatchGrowthParticle() {
        return (SimpleParticleType)ModParticlesForge.NETHERITE_WATCH_GROWTH.get();
    }

    @Override
    public boolean consumeWatchCharge(Player player) {
        AtomicBoolean CHARGE_CONSUMED = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            if (iCuriosItemHandler.isEquipped((Item)ModItemsForge.NETHERITE_WATCH.get())) {
                iCuriosItemHandler.findFirstCurio((Item)ModItemsForge.NETHERITE_WATCH.get()).ifPresent(slotResult -> {
                    if (OverclockedWatchesUtil.handleNetheriteWatchTag(slotResult.stack())) {
                        CHARGE_CONSUMED.set(true);
                    }
                });
            } else if (iCuriosItemHandler.isEquipped((Item)ModItemsForge.DIAMOND_WATCH.get())) {
                iCuriosItemHandler.findFirstCurio((Item)ModItemsForge.DIAMOND_WATCH.get()).ifPresent(slotResult -> {
                    if (OverclockedWatchesUtil.handleDiamondWatchTag(slotResult.stack())) {
                        CHARGE_CONSUMED.set(true);
                    }
                });
            } else if (iCuriosItemHandler.isEquipped((Item)ModItemsForge.GOLDEN_WATCH.get())) {
                iCuriosItemHandler.findFirstCurio((Item)ModItemsForge.GOLDEN_WATCH.get()).ifPresent(slotResult -> {
                    if (OverclockedWatchesUtil.handleGoldenWatchTag(slotResult.stack())) {
                        CHARGE_CONSUMED.set(true);
                    }
                });
            }
        });
        return CHARGE_CONSUMED.get();
    }

    private record WatchCurioRenderer(IWatchRenderer renderer) implements ICurioRenderer
    {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.renderer.render(stack, slotContext.entity(), slotContext.index(), poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

