/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.mixin;

import forge.com.cursee.overclocked_watches.OverclockedWatchesUtil;
import forge.com.cursee.overclocked_watches.platform.Services;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class ForgePlayerMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void injected_$_onTick(CallbackInfo ci) {
        ItemStack equippedWatch;
        Player instancePlayer = (Player)this;
        if (!(instancePlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)instancePlayer;
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (level.m_46467_() % 20L != 0L) {
            return;
        }
        AtomicBoolean FOUND_GOLDEN_WATCH = new AtomicBoolean(false);
        AtomicBoolean FOUND_DIAMOND_WATCH = new AtomicBoolean(false);
        AtomicBoolean FOUND_NETHERITE_WATCH = new AtomicBoolean(false);
        if (Services.PLATFORM.playerHasGoldenWatchEquipped((Player)player)) {
            FOUND_GOLDEN_WATCH.set(true);
        }
        if (Services.PLATFORM.playerHasDiamondWatchEquipped((Player)player)) {
            FOUND_DIAMOND_WATCH.set(true);
        }
        if (Services.PLATFORM.playerHasNetheriteWatchEquipped((Player)player)) {
            FOUND_NETHERITE_WATCH.set(true);
        }
        if (!(FOUND_GOLDEN_WATCH.get() || FOUND_DIAMOND_WATCH.get() || FOUND_NETHERITE_WATCH.get())) {
            return;
        }
        AABB SEARCH_AREA = new AABB(player.m_20183_()).m_82377_(4.0, 0.0, 4.0);
        Iterable SEARCH_POSITIONS = BlockPos.m_121976_((int)((int)SEARCH_AREA.f_82288_), (int)((int)SEARCH_AREA.f_82289_), (int)((int)SEARCH_AREA.f_82290_), (int)((int)SEARCH_AREA.f_82291_), (int)((int)SEARCH_AREA.f_82292_), (int)((int)SEARCH_AREA.f_82293_));
        SEARCH_POSITIONS.forEach(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            Block patt2408$temp = blockState.m_60734_();
            if (!(patt2408$temp instanceof CropBlock)) {
                return;
            }
            CropBlock crop = (CropBlock)patt2408$temp;
            if (crop.m_52307_(blockState)) {
                return;
            }
            if (FOUND_NETHERITE_WATCH.get()) {
                for (int i = 0; i < 4; ++i) {
                    ForgePlayerMixin.unique_$_forceGrowth(crop, blockState, level, blockPos);
                }
                OverclockedWatchesUtil.addNetheriteGrowthParticles(level, blockPos, 8);
            } else if (FOUND_DIAMOND_WATCH.get()) {
                if (level.f_46441_.m_188499_()) {
                    ForgePlayerMixin.unique_$_forceGrowth(crop, blockState, level, blockPos);
                }
                OverclockedWatchesUtil.addDiamondGrowthParticles(level, blockPos, 8);
            } else if (FOUND_GOLDEN_WATCH.get()) {
                if (level.f_46441_.m_188503_(10) == 1) {
                    ForgePlayerMixin.unique_$_forceGrowth(crop, blockState, level, blockPos);
                }
                OverclockedWatchesUtil.addGoldenGrowthParticles(level, blockPos, 8);
            }
        });
        if (FOUND_NETHERITE_WATCH.get() && player.m_217043_().m_216339_(0, 20) == 1) {
            equippedWatch = Services.PLATFORM.getEquippedNetheriteWatch((Player)player);
            equippedWatch.m_220157_(1, player.m_217043_(), player);
            if (equippedWatch.m_41773_() >= equippedWatch.m_41776_()) {
                equippedWatch.m_41774_(1);
            }
        }
        if (FOUND_DIAMOND_WATCH.get() && player.m_217043_().m_216339_(0, 20) == 1) {
            equippedWatch = Services.PLATFORM.getEquippedDiamondWatch((Player)player);
            equippedWatch.m_220157_(1, player.m_217043_(), player);
            if (equippedWatch.m_41773_() >= equippedWatch.m_41776_()) {
                equippedWatch.m_41774_(1);
            }
        }
        if (FOUND_GOLDEN_WATCH.get() && player.m_217043_().m_216339_(0, 20) == 1) {
            equippedWatch = Services.PLATFORM.getEquippedGoldenWatch((Player)player);
            equippedWatch.m_220157_(1, player.m_217043_(), player);
            if (equippedWatch.m_41773_() >= equippedWatch.m_41776_()) {
                equippedWatch.m_41774_(1);
            }
        }
    }

    @Unique
    private static void unique_$_forceGrowth(CropBlock crop, BlockState state, ServerLevel level, BlockPos pos) {
        int currentAge;
        if (level.m_45524_(pos, 0) >= 9 && (currentAge = crop.m_52305_(state)) < crop.m_7419_()) {
            level.m_7731_(pos, crop.m_52289_(currentAge + 1), 2);
        }
    }
}

