/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.core.registry;

import forge.com.cursee.overclocked_watches.core.registry.ModItemsForge;
import forge.com.cursee.overclocked_watches.core.registry.ModParticlesForge;
import forge.com.cursee.overclocked_watches.core.registry.ModTabsForge;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryForge {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"overclocked_watches");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"overclocked_watches");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)BuiltInRegistries.f_279662_.m_123023_(), (String)"overclocked_watches");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"overclocked_watches");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"overclocked_watches");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"overclocked_watches");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"overclocked_watches");

    public static void register(IEventBus modEventBus) {
        ModItemsForge.register();
        ModTabsForge.register();
        ModParticlesForge.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        FEATURES.register(modEventBus);
    }

    protected static <T extends Block> RegistryObject<T> registerBlock(String objectID, Supplier<T> objectSupplier) {
        return BLOCKS.register(objectID, objectSupplier);
    }

    protected static <T extends Item> RegistryObject<T> registerItem(String objectID, Supplier<T> objectSupplier) {
        return ITEMS.register(objectID, objectSupplier);
    }

    protected static <T extends Block> RegistryObject<T> registerBlockWithItem(String objectID, Supplier<T> objectSupplier) {
        RegistryObject toReturn = RegistryForge.registerBlock(objectID, objectSupplier);
        RegistryForge.registerItem(objectID, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    protected static <T extends CreativeModeTab> RegistryObject<T> registerTab(String objectID, Supplier<T> objectSupplier) {
        return TABS.register(objectID, objectSupplier);
    }

    protected static <T extends BlockEntityType<?>> RegistryObject<T> registerBlockEntityType(String objectID, Supplier<T> objectSupplier) {
        return BLOCK_ENTITY_TYPES.register(objectID, objectSupplier);
    }

    protected static <T extends EntityType<?>> RegistryObject<T> registerEntityType(String objectID, Supplier<T> objectSupplier) {
        return ENTITY_TYPES.register(objectID, objectSupplier);
    }

    protected static <T extends ParticleType<?>> RegistryObject<T> registerParticle(String objectID, Supplier<T> objectSupplier) {
        return PARTICLE_TYPES.register(objectID, objectSupplier);
    }

    protected static <T extends Feature<?>> RegistryObject<T> registerFeature(String objectID, Supplier<T> objectSupplier) {
        return FEATURES.register(objectID, objectSupplier);
    }
}

