/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.core.item.custom;

import forge.com.cursee.overclocked_watches.core.ConfiguredValues;
import forge.com.cursee.overclocked_watches.platform.Services;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WatchItem
extends Item {
    public static final String CHARGES = "charges";
    private static final int GOLDEN_CHARGES = (int)ConfiguredValues.GOLDEN_WATCH_CHARGES.get();
    private static final int DIAMOND_CHARGES = (int)ConfiguredValues.DIAMOND_WATCH_CHARGES.get();
    private static final int NETHERITE_CHARGES = (int)ConfiguredValues.NETHERITE_WATCH_CHARGES.get();
    private final Tier tier;

    public WatchItem(Tier tier) {
        super(new Item.Properties().m_41503_(tier.getItemDurability()));
        this.tier = tier;
    }

    public ItemStack m_7968_() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        CompoundTag stackData = itemStack.m_41784_();
        if (stackData.m_128425_(CHARGES, 3)) {
            return itemStack;
        }
        switch (this.getTier()) {
            case GOLDEN: {
                stackData.m_128405_(CHARGES, GOLDEN_CHARGES);
            }
            case DIAMOND: {
                stackData.m_128405_(CHARGES, DIAMOND_CHARGES);
            }
            case NETHERITE: {
                stackData.m_128405_(CHARGES, NETHERITE_CHARGES);
            }
        }
        itemStack.m_41739_(stackData);
        return itemStack.m_41777_();
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag stackData = itemStack.m_41784_();
        if (!stackData.m_128425_(CHARGES, 3)) {
            switch (((WatchItem)itemStack.m_41720_()).getTier()) {
                case GOLDEN: {
                    tooltip.add((Component)Component.m_237110_((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{GOLDEN_CHARGES}));
                    break;
                }
                case DIAMOND: {
                    tooltip.add((Component)Component.m_237110_((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{DIAMOND_CHARGES}));
                    break;
                }
                case NETHERITE: {
                    tooltip.add((Component)Component.m_237110_((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{NETHERITE_CHARGES}));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"text.overclocked_watches.charges", (Object[])new Object[]{stackData.m_128451_(CHARGES)}));
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slotIndex, boolean slotSelected) {
        CompoundTag stackData = itemStack.m_41784_();
        if (stackData.m_128425_(CHARGES, 3)) {
            return;
        }
        switch (((WatchItem)itemStack.m_41720_()).getTier()) {
            case GOLDEN: {
                stackData.m_128405_(CHARGES, GOLDEN_CHARGES);
                break;
            }
            case DIAMOND: {
                stackData.m_128405_(CHARGES, DIAMOND_CHARGES);
                break;
            }
            case NETHERITE: {
                stackData.m_128405_(CHARGES, NETHERITE_CHARGES);
            }
        }
    }

    public static void applyCooldowns(Player player, int lengthInTicks) {
        player.m_36335_().m_41524_(Services.PLATFORM.getRegisteredNetheriteWatchItem().get(), lengthInTicks);
        player.m_36335_().m_41524_(Services.PLATFORM.getRegisteredDiamondWatchItem().get(), lengthInTicks);
        player.m_36335_().m_41524_(Services.PLATFORM.getRegisteredGoldenWatchItem().get(), lengthInTicks);
    }

    public static ItemStack initializeTag(ItemStack itemStack) {
        CompoundTag stackData = itemStack.m_41784_();
        if (stackData.m_128425_(CHARGES, 3)) {
            return itemStack;
        }
        switch (((WatchItem)itemStack.m_41720_()).getTier()) {
            case GOLDEN: {
                stackData.m_128405_(CHARGES, GOLDEN_CHARGES);
                break;
            }
            case DIAMOND: {
                stackData.m_128405_(CHARGES, DIAMOND_CHARGES);
                break;
            }
            case NETHERITE: {
                stackData.m_128405_(CHARGES, NETHERITE_CHARGES);
            }
        }
        itemStack.m_41739_(stackData);
        return itemStack.m_41777_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ServerLevel serverLevel;
        ItemStack itemInHand;
        block17: {
            block16: {
                itemInHand = player.m_21120_(hand);
                if (!(level instanceof ServerLevel)) break block16;
                serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) break block17;
            }
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CompoundTag unvalidatedStackData = itemInHand.m_41784_();
        if (!unvalidatedStackData.m_128425_(CHARGES, 3)) {
            itemInHand = WatchItem.initializeTag(itemInHand);
        } else if (unvalidatedStackData.m_128451_(CHARGES) == 0) {
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        switch (this.getTier()) {
            case GOLDEN: {
                serverLevel.m_8615_((serverLevel.m_46468_() + ConfiguredValues.GOLDEN_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                break;
            }
            case DIAMOND: {
                serverLevel.m_8615_((serverLevel.m_46468_() + ConfiguredValues.DIAMOND_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                break;
            }
            case NETHERITE: {
                serverLevel.m_8615_((serverLevel.m_46468_() + ConfiguredValues.NETHERITE_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
            }
        }
        CompoundTag validatedStackData = itemInHand.m_41784_();
        int newChargeCount = validatedStackData.m_128451_(CHARGES) - 1;
        validatedStackData.m_128473_(CHARGES);
        validatedStackData.m_128405_(CHARGES, newChargeCount);
        itemInHand.m_41739_(validatedStackData);
        switch (this.getTier()) {
            case GOLDEN: {
                WatchItem.applyCooldowns((Player)serverPlayer, 1200 * (int)ConfiguredValues.GOLDEN_WATCH_COOLDOWN_MINUTES.get());
                break;
            }
            case DIAMOND: {
                WatchItem.applyCooldowns((Player)serverPlayer, 1200 * (int)ConfiguredValues.DIAMOND_WATCH_COOLDOWN_MINUTES.get());
                break;
            }
            case NETHERITE: {
                WatchItem.applyCooldowns((Player)serverPlayer, 1200 * (int)ConfiguredValues.NETHERITE_WATCH_COOLDOWN_MINUTES.get());
            }
        }
        return InteractionResultHolder.m_19090_((Object)itemInHand);
    }

    public Tier getTier() {
        return this.tier;
    }

    public static enum Tier {
        GOLDEN(ConfiguredValues.GOLDEN_WATCH_DURABILITY.get()),
        DIAMOND(ConfiguredValues.DIAMOND_WATCH_DURABILITY.get()),
        NETHERITE(ConfiguredValues.NETHERITE_WATCH_DURABILITY.get());

        private final long itemDurability;

        private Tier(long itemDurability) {
            this.itemDurability = itemDurability;
        }

        public int getItemDurability() {
            return (int)this.itemDurability;
        }
    }
}

