/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.core;

import com.cursee.monolib.platform.Services;
import com.cursee.monolib.util.toml.Toml;
import forge.com.cursee.overclocked_watches.Constants;
import forge.com.cursee.overclocked_watches.core.ConfiguredValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ConfigForge
implements IMixinConfigPlugin {
    public static final Map<String, Object> defaults = new HashMap<String, Object>();
    private static final String[] defaultConfigurationStringArray = new String[]{"day_night_cycling_allowed = true", "default_day_night_key = 79", "_comment_ = \"do not change default_day_night_key if you're not sure\"", "", "golden_watch_durability = 100", "diamond_watch_durability = 300", "netherite_watch_durability = 500", "", "golden_watch_charges = 1", "diamond_watch_charges = 3", "netherite_watch_charges = 5", "", "golden_watch_cooldown_minutes = 20", "diamond_watch_cooldown_minutes = 10", "netherite_watch_cooldown_minutes = 5", "", "golden_time_advancement_ticks = 12000", "diamond_time_advancement_ticks = 12000", "netherite_time_advancement_ticks = 12000"};
    static final StringBuilder sBuilder = new StringBuilder();

    public void onLoad(String mixinPackage) {
        defaults.put("day_night_cycling_allowed", ConfiguredValues.DAY_NIGHT_CYCLING_ALLOWED.get());
        defaults.put("default_day_night_key", ConfiguredValues.DEFAULT_DAY_NIGHT_KEY.get());
        defaults.put("_comment_", "do not change default_day_night_key if you're not sure");
        defaults.put("golden_watch_durability", ConfiguredValues.GOLDEN_WATCH_DURABILITY.get());
        defaults.put("diamond_watch_durability", ConfiguredValues.DIAMOND_WATCH_DURABILITY.get());
        defaults.put("netherite_watch_durability", ConfiguredValues.NETHERITE_WATCH_DURABILITY.get());
        defaults.put("golden_watch_charges", ConfiguredValues.GOLDEN_WATCH_CHARGES.get());
        defaults.put("diamond_watch_charges", ConfiguredValues.DIAMOND_WATCH_CHARGES.get());
        defaults.put("netherite_watch_charges", ConfiguredValues.NETHERITE_WATCH_CHARGES.get());
        defaults.put("golden_watch_cooldown_minutes", ConfiguredValues.GOLDEN_WATCH_COOLDOWN_MINUTES.get());
        defaults.put("diamond_watch_cooldown_minutes", ConfiguredValues.DIAMOND_WATCH_COOLDOWN_MINUTES.get());
        defaults.put("netherite_watch_cooldown_minutes", ConfiguredValues.NETHERITE_WATCH_COOLDOWN_MINUTES.get());
        defaults.put("golden_time_advancement_ticks", ConfiguredValues.GOLDEN_TIME_ADVANCEMENT_TICKS.get());
        defaults.put("diamond_time_advancement_ticks", ConfiguredValues.DIAMOND_TIME_ADVANCEMENT_TICKS.get());
        defaults.put("netherite_time_advancement_ticks", ConfiguredValues.NETHERITE_TIME_ADVANCEMENT_TICKS.get());
        File CONFIG_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
        if (!CONFIG_DIRECTORY.isDirectory()) {
            CONFIG_DIRECTORY.mkdir();
        }
        String CONFIG_FILEPATH = CONFIG_DIRECTORY + File.separator + "overclocked_watches.toml";
        File CONFIG_FILE = new File(CONFIG_FILEPATH);
        ConfigForge.handle(CONFIG_FILE);
    }

    private static void handle(File file) {
        if (!file.isFile()) {
            ConfigForge.createConfigurationFile(file);
        } else {
            ConfigForge.loadConfigurationFile(file);
        }
    }

    private static void createConfigurationFile(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String s : defaultConfigurationStringArray) {
                sBuilder.append(s).append('\n');
            }
            bufferedWriter.write(sBuilder.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException exception) {
            Constants.LOG.error("Fatal error occurred while attempting to write overclocked_watches.toml");
            Constants.LOG.error("Did another process delete the config directory during writing?");
            Constants.LOG.error(exception.getMessage());
        }
    }

    private static void loadConfigurationFile(File file) {
        try {
            Toml toml = new Toml().read(file);
            ConfiguredValues.DEFAULT_DAY_NIGHT_KEY.set(toml.getLong("default_day_night_key"));
            ConfiguredValues.DAY_NIGHT_CYCLING_ALLOWED.set(toml.getBoolean("day_night_cycling_allowed"));
            ConfiguredValues.GOLDEN_WATCH_DURABILITY.set(toml.getLong("golden_watch_durability"));
            ConfiguredValues.DIAMOND_WATCH_DURABILITY.set(toml.getLong("diamond_watch_durability"));
            ConfiguredValues.NETHERITE_WATCH_DURABILITY.set(toml.getLong("netherite_watch_durability"));
            ConfiguredValues.GOLDEN_WATCH_CHARGES.set(toml.getLong("golden_watch_charges"));
            ConfiguredValues.DIAMOND_WATCH_CHARGES.set(toml.getLong("diamond_watch_charges"));
            ConfiguredValues.NETHERITE_WATCH_CHARGES.set(toml.getLong("netherite_watch_charges"));
            ConfiguredValues.GOLDEN_WATCH_COOLDOWN_MINUTES.set(toml.getLong("golden_watch_cooldown_minutes"));
            ConfiguredValues.DIAMOND_WATCH_COOLDOWN_MINUTES.set(toml.getLong("diamond_watch_cooldown_minutes"));
            ConfiguredValues.NETHERITE_WATCH_COOLDOWN_MINUTES.set(toml.getLong("netherite_watch_cooldown_minutes"));
            ConfiguredValues.GOLDEN_TIME_ADVANCEMENT_TICKS.set(toml.getLong("golden_time_advancement_ticks"));
            ConfiguredValues.DIAMOND_TIME_ADVANCEMENT_TICKS.set(toml.getLong("diamond_time_advancement_ticks"));
            ConfiguredValues.NETHERITE_TIME_ADVANCEMENT_TICKS.set(toml.getLong("netherite_time_advancement_ticks"));
        }
        catch (IllegalStateException exception) {
            Constants.LOG.error("Fatal error occurred while attempting to read overclocked_watches.toml");
            Constants.LOG.error("Did another process delete the file during reading?");
            Constants.LOG.error(exception.getMessage());
        }
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

